/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nullable;

public enum SpringBootValueProvider {
    ANY("any", "Permit any additional values to be provided", new Parameter[0]),
    CLASS_REFERENCE("class-reference", "Classes available in the project. Usually constrained by a base class specified via 'target' parameter.", new Parameter("target", false), new Parameter("concrete", false)),
    HANDLE_AS("handle-as", "Handle the property as if it was defined by the type defined via the mandatory 'target' parameter.", new Parameter("target", true)),
    LOGGER_NAME("logger-name", "Valid logger names. Typically, package and class names available in the current project.", new Parameter[0]),
    SPRING_BEAN_REFERENCE("spring-bean-reference", "Available bean names in the current project. Usually constrained by a base class specified via 'target' parameter.", new Parameter("target", false)),
    SPRING_PROFILE_NAME("spring-profile-name", "Available profile names in the project.", new Parameter[0]);

    private final String myId;
    private final String myDescription;
    private final Parameter[] myParameters;
    private final boolean myHasRequiredParameters;

    private SpringBootValueProvider(String id, String description, Parameter ... parameters) {
        this.myId = id;
        this.myDescription = description;
        this.myParameters = parameters;
        this.myHasRequiredParameters = this.calcHasRequiredParameters();
    }

    public String getId() {
        return this.myId;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public Parameter[] getParameters() {
        return this.myParameters;
    }

    public boolean hasRequiredParameters() {
        return this.myHasRequiredParameters;
    }

    private boolean calcHasRequiredParameters() {
        for (Parameter parameter : this.myParameters) {
            if (!parameter.isRequired()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static SpringBootValueProvider findById(final String id) {
        return (SpringBootValueProvider)((Object)ContainerUtil.find((Object[])SpringBootValueProvider.values(), (Condition)new Condition<SpringBootValueProvider>(){

            public boolean value(SpringBootValueProvider provider) {
                return provider.getId().equals(id);
            }
        }));
    }

    public static class Parameter {
        private final String myName;
        private final boolean myRequired;

        Parameter(String name, boolean required) {
            this.myName = name;
            this.myRequired = required;
        }

        public String getName() {
            return this.myName;
        }

        public boolean isRequired() {
            return this.myRequired;
        }
    }
}

