/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.spring.boot.application.properties.MapKeyPropertyEnumReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MapKeyEnumReference
extends MapKeyPropertyEnumReferenceSet.MyReference
implements EmptyResolveMessageProvider {
    MapKeyEnumReference(PsiElement element, TextRange textRange, MapKeyPropertyEnumReferenceSet referenceSet, int index) {
        super(element, textRange, referenceSet, index);
    }

    @Nullable
    public PsiElement resolve() {
        PsiClass keyClass = this.getKeyClass();
        if (keyClass == null) {
            return null;
        }
        final String enumText = this.getValue();
        return (PsiElement)ContainerUtil.find((Object[])keyClass.getFields(), (Condition)new Condition<PsiField>(){

            public boolean value(PsiField field) {
                return field instanceof PsiEnumConstant && enumText.equalsIgnoreCase(field.getName());
            }
        });
    }

    @NotNull
    public Object[] getVariants() {
        PsiClass keyClass = this.getKeyClass();
        if (keyClass == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/MapKeyEnumReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        Object[] enumConstants = (PsiField[])ContainerUtil.findAllAsArray((Object[])keyClass.getFields(), (Condition)Conditions.instanceOf(PsiEnumConstant.class));
        Object[] objectArray = ContainerUtil.map2Array((Object[])enumConstants, LookupElement.class, (Function)new Function<PsiField, LookupElement>(){

            public LookupElement fun(PsiField field) {
                String fieldName = field.getName();
                assert (fieldName != null) : field;
                String enumLowerCaseName = fieldName.toLowerCase(Locale.US);
                LookupElementBuilder builder = LookupElementBuilder.create((Object)field, (String)enumLowerCaseName).withIcon(field.getIcon(1)).withPresentableText(fieldName);
                return TailTypeDecorator.withTail((LookupElement)builder, (TailType)(MapKeyEnumReference.this.isEnumMapKey() ? TailType.createSimpleTailType((char)MapKeyEnumReference.this.getKeyValueDelimiter()) : TailType.DOT));
            }
        });
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/MapKeyEnumReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String location = this.getKeyClass() == null ? "" : " in " + this.getKeyClass().getQualifiedName();
        String string = "Cannot resolve enum constant '" + this.getValue() + "'" + location;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/MapKeyEnumReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    @Override
    @Nullable
    protected PsiClass getKeyClass() {
        return this.isFirst() ? this.getInitialKeyClass() : this.getPrevious().getKeyClass();
    }

    @Override
    @Nullable
    protected PsiClass getValueClass() {
        return this.isFirst() ? this.getInitialValueClass() : this.getPrevious().getValueClass();
    }
}

