/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.properties.MapKeyEnumReference;
import com.intellij.spring.boot.application.properties.MapKeyPropertyEnumReferenceSet;
import com.intellij.spring.boot.application.properties.MapKeyPropertyReference;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesPlaceholderReference;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;

public class SpringBootApplicationPropertiesAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesAnnotator", "annotate"));
        }
        if (!(element instanceof PropertyValueImpl) && !(element instanceof PropertyKeyImpl)) {
            return;
        }
        PsiFile file = holder.getCurrentAnnotationSession().getFile();
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        if (!SpringBootApplicationPropertiesUtil.isApplicationPropertiesFile((PropertiesFile)file)) {
            return;
        }
        if (element instanceof PropertyValueImpl) {
            SpringBootApplicationPropertiesAnnotator.annotateValue(element, holder);
        }
        if (element instanceof PropertyKeyImpl) {
            SpringBootApplicationPropertiesAnnotator.annotateKey((PropertyKeyImpl)element, holder);
        }
    }

    private static void annotateValue(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesAnnotator", "annotateValue"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesAnnotator", "annotateValue"));
        }
        for (PsiReference reference : element.getReferences()) {
            if (!(reference instanceof SpringBootApplicationPropertiesPlaceholderReference)) continue;
            int elementOffset = element.getNode().getStartOffset();
            Annotation annotation = holder.createInfoAnnotation(reference.getRangeInElement().shiftRight(elementOffset), null);
            annotation.setTextAttributes(PropertiesHighlighter.PROPERTY_KEY);
        }
    }

    private static void annotateKey(PropertyKeyImpl element, AnnotationHolder holder) {
        SpringBootApplicationMetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)element);
        if (configKey == null) {
            return;
        }
        String keyText = element.getText();
        int elementStartOffset = element.getNode().getStartOffset();
        SpringBootApplicationPropertiesAnnotator.annotateIndexAccessExpressions(holder, keyText, configKey, elementStartOffset);
        if (configKey.isEnumMapType() || configKey.isIndexedType()) {
            for (PsiReference reference : element.getReferences()) {
                if (!(reference instanceof MapKeyPropertyEnumReferenceSet.MyReference)) continue;
                TextRange referenceRange = reference.getRangeInElement().shiftRight(elementStartOffset);
                Annotation annotation = holder.createInfoAnnotation(referenceRange, null);
                if (reference instanceof MapKeyEnumReference) {
                    annotation.setTextAttributes(DefaultLanguageHighlighterColors.CONSTANT);
                    continue;
                }
                if (!(reference instanceof MapKeyPropertyReference)) continue;
                annotation.setTextAttributes(DefaultLanguageHighlighterColors.INSTANCE_METHOD);
            }
        } else if (configKey.isMapType()) {
            int configKeyNameLength = -1;
            for (PsiReference reference : element.getReferences()) {
                if (!(reference instanceof MetaConfigKeyReference)) continue;
                configKeyNameLength = reference.getRangeInElement().getEndOffset();
                break;
            }
            assert (configKeyNameLength != -1) : keyText;
            int endOffset = keyText.length() - configKeyNameLength - (StringUtil.endsWithChar((CharSequence)keyText, (char)']') ? 2 : 1);
            if (endOffset < 0) {
                return;
            }
            TextRange genericKeyRange = TextRange.from((int)(configKeyNameLength + 1), (int)endOffset).shiftRight(elementStartOffset);
            Annotation annotation = holder.createInfoAnnotation(genericKeyRange, null);
            annotation.setEnforcedTextAttributes(SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES.toTextAttributes());
        }
    }

    private static void annotateIndexAccessExpressions(AnnotationHolder holder, String text, SpringBootApplicationMetaConfigKey configKey, int elementStartOffset) {
        boolean isPlainMapKey = configKey.isMapType() && !configKey.isEnumMapType();
        int parseOffset = 0;
        int startIdx;
        while ((startIdx = StringUtil.indexOf((CharSequence)text, (char)'[', (int)parseOffset)) != -1) {
            int endIdx;
            parseOffset = endIdx = StringUtil.indexOf((CharSequence)text, (char)']', (int)startIdx);
            if (endIdx == -1) {
                holder.createErrorAnnotation(TextRange.from((int)startIdx, (int)1).shiftRight(elementStartOffset), "Missing closing ']'");
                parseOffset = startIdx + 1;
                continue;
            }
            if (startIdx + 1 == endIdx) {
                holder.createErrorAnnotation(TextRange.from((int)startIdx, (int)2).shiftRight(elementStartOffset), "Missing index value");
                continue;
            }
            TextRange indexValueRange = TextRange.create((int)(startIdx + 1), (int)endIdx);
            String indexValueText = indexValueRange.substring(text);
            try {
                holder.createInfoAnnotation(TextRange.from((int)startIdx, (int)1).shiftRight(elementStartOffset), null).setTextAttributes(DefaultLanguageHighlighterColors.BRACKETS);
                if (!isPlainMapKey) {
                    Integer.decode(indexValueText);
                    holder.createInfoAnnotation(indexValueRange.shiftRight(elementStartOffset), null).setTextAttributes(DefaultLanguageHighlighterColors.NUMBER);
                }
                holder.createInfoAnnotation(TextRange.from((int)endIdx, (int)1).shiftRight(elementStartOffset), null).setTextAttributes(DefaultLanguageHighlighterColors.BRACKETS);
                continue;
            }
            catch (NumberFormatException e) {
                holder.createErrorAnnotation(indexValueRange.shiftRight(elementStartOffset), "Index value must be Integer");
                continue;
            }
            break;
        }
        return;
    }
}

