/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.facet;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.facet.searchers.ConfigSearcherScopeModifier;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringBootAutoConfigureConfigSearcherScopeModifier
extends ConfigSearcherScopeModifier {
    @NotNull
    public GlobalSearchScope modifyScope(@NotNull Module module, @NotNull GlobalSearchScope originalScope) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/facet/SpringBootAutoConfigureConfigSearcherScopeModifier", "modifyScope"));
        }
        if (originalScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalScope", "com/intellij/spring/boot/facet/SpringBootAutoConfigureConfigSearcherScopeModifier", "modifyScope"));
        }
        List autoConfigs = SpringSpiManager.getInstance((Module)module).getClassesListValue(true, "org.springframework.boot.autoconfigure.EnableAutoConfiguration");
        if (autoConfigs.isEmpty()) {
            GlobalSearchScope globalSearchScope = originalScope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/facet/SpringBootAutoConfigureConfigSearcherScopeModifier", "modifyScope"));
            }
            return globalSearchScope;
        }
        ArrayList<VirtualFile> allConfigFiles = new ArrayList<VirtualFile>(autoConfigs.size());
        for (PsiClass psiClass : autoConfigs) {
            SpringBootAutoConfigureConfigSearcherScopeModifier.processPsiClass(allConfigFiles, psiClass);
            for (PsiClass innerClass : psiClass.getInnerClasses()) {
                SpringBootAutoConfigureConfigSearcherScopeModifier.processPsiClass(allConfigFiles, innerClass);
            }
        }
        GlobalSearchScope configFilesScope = GlobalSearchScope.filesScope((Project)module.getProject(), allConfigFiles);
        GlobalSearchScope globalSearchScope = originalScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)configFilesScope));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/facet/SpringBootAutoConfigureConfigSearcherScopeModifier", "modifyScope"));
        }
        return globalSearchScope;
    }

    private static void processPsiClass(final List<VirtualFile> allConfigFiles, PsiClass psiClass) {
        SpringConfiguration springConfiguration = (SpringConfiguration)SpringConfiguration.META.getJamElement((PsiModifierListOwner)psiClass);
        if (springConfiguration == null) {
            return;
        }
        final ArrayList<PsiClass> allPsiClasses = new ArrayList<PsiClass>();
        allPsiClasses.add(psiClass);
        SpringBootAutoConfigureConfigSearcherScopeModifier.addImports(allPsiClasses, psiClass);
        SpringBootAutoConfigureConfigSearcherScopeModifier.addXmlImports(allConfigFiles, psiClass);
        SpringJamUtils.getInstance().processCustomAnnotations(psiClass, (Processor)new Processor<Pair<PsiClass, LocalModelDependency>>(){

            public boolean process(Pair<PsiClass, LocalModelDependency> pair) {
                PsiClass enableAnno = (PsiClass)pair.first;
                SpringBootAutoConfigureConfigSearcherScopeModifier.addImports(allPsiClasses, enableAnno);
                SpringBootAutoConfigureConfigSearcherScopeModifier.addXmlImports(allConfigFiles, enableAnno);
                return true;
            }
        });
        allConfigFiles.addAll(ContainerUtil.map(allPsiClasses, (Function)new Function<PsiClass, VirtualFile>(){

            public VirtualFile fun(PsiClass psiClass) {
                return psiClass.getContainingFile().getVirtualFile();
            }
        }));
    }

    private static void addXmlImports(List<VirtualFile> configFiles, PsiClass psiClass) {
        Set xmlConfigs = SpringJamUtils.getInstance().getImportedResources(psiClass, new Module[0]);
        configFiles.addAll(ContainerUtil.map((Collection)xmlConfigs, (Function)new Function<XmlFile, VirtualFile>(){

            public VirtualFile fun(XmlFile xmlFile) {
                return xmlFile.getVirtualFile();
            }
        }));
    }

    private static void addImports(List<PsiClass> allPsiClasses, PsiClass psiClass) {
        Set importedClasses = SpringJamUtils.getInstance().getImportedClasses(psiClass, null);
        allPsiClasses.addAll(importedClasses);
    }
}

