/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.properties;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.spring.boot.application.config.SpringBootConfigurationPropertyReferenceSearcher;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringBootApiIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationPropertyRelatedItemLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static final String POPUP_TITLE = "Spring Boot Configuration Files";
    private static final NotNullFunction<PsiReference, Collection<? extends GotoRelatedItem>> RELATED_ITEM_CONVERTER = new NotNullFunction<PsiReference, Collection<? extends GotoRelatedItem>>(){

        @NotNull
        public Collection<? extends GotoRelatedItem> fun(PsiReference reference) {
            final MyNavigationFakeElement fakeElement = new MyNavigationFakeElement((MetaConfigKeyReference)reference);
            Set<1> set = Collections.singleton(new GotoRelatedItem((PsiElement)fakeElement, ConfigurationPropertyRelatedItemLineMarkerProvider.POPUP_TITLE){

                @Nullable
                public String getCustomContainerName() {
                    return fakeElement.getPresentation().getLocationString();
                }
            });
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/properties/ConfigurationPropertyRelatedItemLineMarkerProvider$1", "fun"));
            }
            return set;
        }
    };
    private static final NotNullFunction<PsiReference, Collection<? extends PsiElement>> PSI_REFERENCE_CONVERTER = new NotNullFunction<PsiReference, Collection<? extends PsiElement>>(){

        @NotNull
        public Collection<? extends PsiElement> fun(PsiReference reference) {
            Set<MyNavigationFakeElement> set = Collections.singleton(new MyNavigationFakeElement((MetaConfigKeyReference)reference));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/properties/ConfigurationPropertyRelatedItemLineMarkerProvider$2", "fun"));
            }
            return set;
        }
    };
    private static final Processor<PsiReference> HAS_META_CONFIG_KEY_PROCESSOR = new Processor<PsiReference>(){

        public boolean process(PsiReference reference) {
            return !(reference instanceof MetaConfigKeyReference);
        }
    };

    public String getId() {
        return "ConfigurationPropertyRelatedItemLineMarkerProvider";
    }

    public String getName() {
        return "Configuration Properties";
    }

    @Nullable
    public Icon getIcon() {
        return SpringBootApiIcons.SpringBoot;
    }

    public void collectNavigationMarkers(List<PsiElement> elements, Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (psiElement == null || !SpringBootLibraryUtil.hasSpringBootLibrary(psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/model/properties/ConfigurationPropertyRelatedItemLineMarkerProvider", "collectNavigationMarkers"));
        }
        if (!(element instanceof PsiMethod)) {
            return;
        }
        final PsiMethod psiMethod = (PsiMethod)element;
        String prefix = SpringBootConfigurationPropertyReferenceSearcher.getPrefixIfRelevantPropertyMethod(psiMethod, true);
        if (prefix == null) {
            return;
        }
        GlobalSearchScope fakeScope = GlobalSearchScope.fileScope((PsiFile)psiMethod.getContainingFile());
        Query search = MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)fakeScope, (boolean)true);
        if (search.forEach(HAS_META_CONFIG_KEY_PROCESSOR)) {
            return;
        }
        PsiIdentifier nameIdentifier = psiMethod.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        RelatedItemLineMarkerInfo info = NavigationGutterIconBuilder.create((Icon)SpringBootApiIcons.SpringBoot, PSI_REFERENCE_CONVERTER, RELATED_ITEM_CONVERTER).setTooltipText("Usage in Spring Boot Configuration Files").setPopupTitle(POPUP_TITLE).setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends PsiReference>>(){

            @NotNull
            protected Collection<? extends PsiReference> compute() {
                Collection collection = MethodReferencesSearch.search((PsiMethod)psiMethod).findAll();
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/properties/ConfigurationPropertyRelatedItemLineMarkerProvider$4", "compute"));
                }
                return collection;
            }
        }).createLineMarkerInfo((PsiElement)nameIdentifier);
        result.add((RelatedItemLineMarkerInfo)info);
    }

    static class MyNavigationFakeElement
    extends FakePsiElement {
        private final PsiElement myElement;
        private final MetaConfigKeyReference myReference;

        private MyNavigationFakeElement(MetaConfigKeyReference reference) {
            this.myReference = reference;
            this.myElement = reference.getElement();
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/properties/ConfigurationPropertyRelatedItemLineMarkerProvider$MyNavigationFakeElement", "getNavigationElement"));
            }
            return psiElement;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return MyNavigationFakeElement.getListItemIcon(this.myElement);
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = new PresentationData(this.myReference.getReferenceDisplayText(), "(" + SymbolPresentationUtil.getFilePathPresentation((PsiFile)this.myElement.getContainingFile()) + ")", MyNavigationFakeElement.getListItemIcon(this.myElement), null);
            if (presentationData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/properties/ConfigurationPropertyRelatedItemLineMarkerProvider$MyNavigationFakeElement", "getPresentation"));
            }
            return presentationData;
        }

        public PsiElement getParent() {
            return this.myElement;
        }

        private static Icon getListItemIcon(PsiElement navigationItem) {
            return navigationItem.getContainingFile().getIcon(0);
        }
    }
}

