/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model.jam;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.integration.model.jam.MessagingGateway;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MessagingGatewaysSearchUtil {
    public static List<CommonSpringBean> getAllMessagingGateways(final @NotNull Module module, @NotNull Key<CachedValue<List<CommonSpringBean>>> cachedValueKey) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/integration/model/jam/MessagingGatewaysSearchUtil", "getAllMessagingGateways"));
        }
        if (cachedValueKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedValueKey", "com/intellij/spring/integration/model/jam/MessagingGatewaysSearchUtil", "getAllMessagingGateways"));
        }
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, cachedValueKey, (CachedValueProvider)new CachedValueProvider<List<CommonSpringBean>>(){

            public CachedValueProvider.Result<List<CommonSpringBean>> compute() {
                SmartList result = new SmartList();
                result.addAll(MessagingGatewaysSearchUtil.getMessagingGateways(module));
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        }, false);
    }

    @NotNull
    public static List<MessagingGateway> getMessagingGateways(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/integration/model/jam/MessagingGatewaysSearchUtil", "getMessagingGateways"));
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        JamService jamService = JamService.getJamService((Project)module.getProject());
        List messagingGateways = ContainerUtil.newSmartList();
        for (String anno : MessagingGateway.getMessagingGatewayAnnotations(module)) {
            messagingGateways.addAll(jamService.getJamClassElements(MessagingGateway.META, anno, scope));
        }
        List list = messagingGateways;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/model/jam/MessagingGatewaysSearchUtil", "getMessagingGateways"));
        }
        return list;
    }
}

