/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.firefox.FirefoxBreakpoint;
import com.jetbrains.firefox.FirefoxCommandProcessor;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.FirefoxVm;
import com.jetbrains.firefox.rdp.Location;
import com.jetbrains.firefox.rdp.SetBreakpointResult;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointManagerBase;
import org.jetbrains.debugger.BreakpointTarget;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J:\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J(\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u001aJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/firefox/FirefoxBreakpointManager;", "Lorg/jetbrains/debugger/BreakpointManagerBase;", "Lcom/jetbrains/firefox/FirefoxBreakpoint;", "vm", "Lcom/jetbrains/firefox/FirefoxVm;", "(Lcom/jetbrains/firefox/FirefoxVm;)V", "createBreakpoint", "target", "Lorg/jetbrains/debugger/BreakpointTarget;", "line", "", "column", "condition", "", "ignoreCount", "enabled", "", "doClearBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "Ljava/lang/Void;", "breakpoint", "doSetBreakpoint", "Lorg/jetbrains/debugger/Breakpoint;", "url", "Lcom/intellij/util/Url;", "findRelatedBreakpoints", "", "breakpointActors", "getMuteMode", "Lorg/jetbrains/debugger/BreakpointManager$MUTE_MODE;", "FirefoxConnector"})
public final class FirefoxBreakpointManager
extends BreakpointManagerBase<FirefoxBreakpoint> {
    private final FirefoxVm vm;

    @NotNull
    public final List<Breakpoint> findRelatedBreakpoints(@Nullable List<String> breakpointActors) {
        if (ContainerUtil.isEmpty((Collection)breakpointActors)) {
            return CollectionsKt.emptyList();
        }
        SmartList result = new SmartList();
        for (FirefoxBreakpoint breakpoint : this.getBreakpoints()) {
            String actor = breakpoint.getActor();
            if (actor == null) continue;
            List<String> list = breakpointActors;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            if (!list.contains(actor)) continue;
            result.add((Object)breakpoint);
        }
        return (List)result;
    }

    @NotNull
    protected FirefoxBreakpoint createBreakpoint(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, int ignoreCount, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return new FirefoxBreakpoint(target, line, column, condition, enabled);
    }

    @NotNull
    protected Promise<Breakpoint> doSetBreakpoint(@NotNull BreakpointTarget target, @Nullable Url url, @NotNull FirefoxBreakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)((Object)breakpoint), (String)"breakpoint");
        BreakpointTarget breakpointTarget = target;
        if (breakpointTarget == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.BreakpointTarget.ScriptName");
        }
        String scriptUrl = ((BreakpointTarget.ScriptName)breakpointTarget).getName();
        FirefoxCommandProcessor firefoxCommandProcessor = this.vm.getCommandProcessor();
        String string = this.vm.getThreadActor();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = scriptUrl;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"scriptUrl");
        Promise promise = firefoxCommandProcessor.send(FirefoxRequest.Companion.setBreakpoint(string, string2, breakpoint.getLine(), breakpoint.getColumn())).then((Function)new Function<SetBreakpointResult, Breakpoint>(this, scriptUrl, breakpoint){
            final /* synthetic */ FirefoxBreakpointManager this$0;
            final /* synthetic */ String $scriptUrl;
            final /* synthetic */ FirefoxBreakpoint $breakpoint;

            @NotNull
            public Breakpoint fun(@NotNull SetBreakpointResult result) {
                org.jetbrains.debugger.Location location;
                Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                Location rawLocation = result.actualLocation();
                if (rawLocation == null) {
                    Url url = Urls.parseEncoded((String)this.$scriptUrl);
                    if (url == null) {
                        Intrinsics.throwNpe();
                    }
                    location = new org.jetbrains.debugger.Location(url, this.$breakpoint.getLine(), this.$breakpoint.getColumn());
                } else {
                    Url url = Urls.parseEncoded((String)rawLocation.url());
                    if (url == null) {
                        Intrinsics.throwNpe();
                    }
                    location = new org.jetbrains.debugger.Location(url, rawLocation.line() - 1, rawLocation.column());
                }
                this.$breakpoint.setRemoteData(result.actor(), location);
                FirefoxBreakpointManager.access$notifyBreakpointResolvedListener(this.this$0, this.$breakpoint);
                return (Breakpoint)this.$breakpoint;
            }
            {
                this.this$0 = $outer;
                this.$scriptUrl = $captured_local_variable$1;
                this.$breakpoint = $captured_local_variable$2;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"vm.commandProcessor.send\u2026breakpoint\n      }\n    })");
        return promise;
    }

    @NotNull
    protected Promise<Void> doClearBreakpoint(@NotNull FirefoxBreakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)breakpoint), (String)"breakpoint");
        FirefoxCommandProcessor firefoxCommandProcessor = this.vm.getCommandProcessor();
        String string = breakpoint.getActor();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return firefoxCommandProcessor.send(FirefoxRequest.Companion.deleteBreakpoint(string));
    }

    @NotNull
    public BreakpointManager.MUTE_MODE getMuteMode() {
        return BreakpointManager.MUTE_MODE.NONE;
    }

    public FirefoxBreakpointManager(@NotNull FirefoxVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
    }

    public static final /* synthetic */ void access$notifyBreakpointResolvedListener(FirefoxBreakpointManager $this, @NotNull FirefoxBreakpoint breakpoint) {
        $this.notifyBreakpointResolvedListener(breakpoint);
    }
}

