/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.firefox.FirefoxCommandProcessor$WhenMappings;
import com.jetbrains.firefox.FirefoxListener;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.rdp.FirefoxProtocolReaderImpl;
import com.jetbrains.firefox.rdp.PropertyResult;
import com.jetbrains.firefox.rdp.PrototypeResult;
import com.jetbrains.firefox.rdp.Source;
import com.jetbrains.firefox.rdp.ThreadInterrupted;
import gnu.trove.THashMap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.util.EventListener;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.ChannelBufferToString;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.rpc.CommandSenderBase;
import org.jetbrains.rpc.MessageManagerBase;
import org.jetbrains.rpc.MessageManagerBaseKt;
import org.jetbrains.rpc.MessageProcessor;
import org.jetbrains.rpc.RequestCallback;
import org.jetbrains.rpc.RequestPromise;
import org.jetbrains.rpc.ResultReader;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000 52\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u000556789B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u001bH\u0016J\u0006\u0010#\u001a\u00020\u001bJ\b\u0010$\u001a\u00020\u001bH\u0016J0\u0010%\u001a\u00020\u001b\"\u0004\b\u0000\u0010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H&0*H\u0014J*\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u00132\u0006\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u0013H\u0002J@\u00101\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u00132\u0006\u0010/\u001a\u00020\u00132\b\u00102\u001a\u0004\u0018\u00010\u00132\b\u00103\u001a\u0004\u0018\u00010\u00132\b\u00100\u001a\u0004\u0018\u00010\u0013H\u0002J\u000e\u00104\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-R2\u0010\t\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a#\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00130\u0013\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00140\u00140\u0012\u00a2\u0006\u0002\b\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor;", "Lorg/jetbrains/rpc/CommandSenderBase;", "", "Lorg/jetbrains/rpc/MessageProcessor;", "writer", "Lkotlin/Function1;", "Lio/netty/buffer/ByteBuf;", "", "(Lkotlin/jvm/functions/Function1;)V", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/jetbrains/firefox/FirefoxCommandProcessor$IFirefoxListener;", "kotlin.jvm.PlatformType", "isBreakOnException", "()Z", "messageManager", "Lcom/jetbrains/firefox/FirefoxCommandProcessor$FirefoxMessageManager;", "threadToState", "Ljava/util/concurrent/ConcurrentMap;", "", "Lcom/jetbrains/firefox/FirefoxCommandProcessor$ThreadState;", "Lorg/jetbrains/annotations/NotNull;", "getThreadToState", "()Ljava/util/concurrent/ConcurrentMap;", "addInitialMessageHandler", "Lorg/jetbrains/concurrency/Promise;", "addListener", "", "listener", "Lcom/jetbrains/firefox/FirefoxListener;", "attachToThreadAndExecute", "thread", "runnable", "Ljava/lang/Runnable;", "cancelWaitingRequests", "clear", "closed", "doSend", "RESULT", "message", "Lorg/jetbrains/jsonProtocol/Request;", "callback", "Lorg/jetbrains/rpc/RequestPromise;", "handleEvent", "reader", "Lorg/jetbrains/io/JsonReaderEx;", "nextName", "actor", "type", "handleResponseOrEvent", "error", "errorDescription", "processIncomingJson", "Companion", "FirefoxMessageManager", "IFirefoxListener", "RequestItem", "ThreadState", "FirefoxConnector"})
public final class FirefoxCommandProcessor
extends CommandSenderBase<Object>
implements MessageProcessor {
    private final FirefoxMessageManager messageManager;
    @NotNull
    private final ConcurrentMap<String, ThreadState> threadToState;
    private final EventDispatcher<IFirefoxListener> dispatcher;
    private final boolean isBreakOnException = false;
    private final Function1<ByteBuf, Boolean> writer;
    private static final FirefoxProtocolReaderImpl READER;
    public static final Companion Companion;

    @NotNull
    public final ConcurrentMap<String, ThreadState> getThreadToState() {
        return this.threadToState;
    }

    public final boolean isBreakOnException() {
        return this.isBreakOnException;
    }

    @NotNull
    public final Promise<?> addInitialMessageHandler() {
        RequestPromise promise = new RequestPromise("initial");
        this.messageManager.getActorToCurrentItem().put((Object)"root", (Object)new RequestItem(null, FirefoxRequest.Method.INITIAL, (RequestCallback<Object>)((RequestCallback)promise)));
        return (Promise)promise;
    }

    public final void addListener(@NotNull FirefoxListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.dispatcher.addListener((EventListener)listener);
    }

    public void cancelWaitingRequests() {
        this.messageManager.cancelWaitingRequests();
    }

    public void closed() {
        this.messageManager.closed();
    }

    public final void attachToThreadAndExecute(@NotNull String thread, @NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        ThreadState state = (ThreadState)((Object)this.threadToState.get(thread));
        if (state != null) {
            CommandProcessorKt.getLOG().assertTrue(Intrinsics.areEqual((Object)((Object)state), (Object)((Object)ThreadState.PAUSED)));
            runnable.run();
            return;
        }
        this.send(FirefoxRequest.Companion.attachToThread(thread)).done(new Consumer<? super T>(this, thread, runnable){
            final /* synthetic */ FirefoxCommandProcessor this$0;
            final /* synthetic */ String $thread;
            final /* synthetic */ Runnable $runnable;

            public final void consume(ThreadInterrupted it) {
                boolean resume = this.this$0.getThreadToState().putIfAbsent(this.$thread, ThreadState.PAUSED) == null && Intrinsics.areEqual((Object)((Object)it.why().type()), (Object)((Object)ThreadInterrupted.Reason.Type.ATTACHED));
                try {
                    this.$runnable.run();
                }
                catch (Exception e) {
                    CommandProcessorKt.getLOG().error((Throwable)e);
                }
                if (resume) {
                    this.this$0.send(FirefoxRequest.Companion.resumeThread(this.$thread, this.this$0.isBreakOnException()));
                }
            }
            {
                this.this$0 = firefoxCommandProcessor;
                this.$thread = string;
                this.$runnable = runnable;
            }
        });
    }

    protected <RESULT> void doSend(@NotNull Request<RESULT> message, @NotNull RequestPromise<Object, RESULT> callback) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Request<RESULT> request = message;
        if (request == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.firefox.FirefoxRequest<kotlin.Any>");
        }
        FirefoxRequest request2 = (FirefoxRequest)request;
        if (request2.getMethod() == FirefoxRequest.Method.SET_BREAKPOINT) {
            ThreadState state = (ThreadState)((Object)this.threadToState.get(request2.getActor()));
            if (Intrinsics.areEqual((Object)((Object)state), (Object)((Object)ThreadState.RUNNING))) {
                this.send(FirefoxRequest.Companion.interrupt(request2.getActor())).done(new Consumer<? super T>(this, request2, callback){
                    final /* synthetic */ FirefoxCommandProcessor this$0;
                    final /* synthetic */ FirefoxRequest $request;
                    final /* synthetic */ RequestPromise $callback;

                    public final void consume(ThreadInterrupted it) {
                        FirefoxCommandProcessor.access$getMessageManager$p(this.this$0).send(this.$request, (RequestCallback<Object>)((RequestCallback)this.$callback));
                        if (Intrinsics.areEqual((Object)((Object)it.why().type()), (Object)((Object)ThreadInterrupted.Reason.Type.INTERRUPTED))) {
                            this.this$0.send(FirefoxRequest.Companion.resumeThread(this.$request.getActor(), this.this$0.isBreakOnException()));
                        }
                    }
                    {
                        this.this$0 = firefoxCommandProcessor;
                        this.$request = firefoxRequest;
                        this.$callback = requestPromise;
                    }
                }).rejected((Consumer)new Consumer<Throwable>(callback){
                    final /* synthetic */ RequestPromise $callback;

                    public final void consume(Throwable it) {
                        Throwable throwable = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                        this.$callback.onError(throwable);
                    }
                    {
                        this.$callback = requestPromise;
                    }
                });
                return;
            }
            CommandProcessorKt.getLOG().assertTrue(Intrinsics.areEqual((Object)((Object)state), (Object)((Object)ThreadState.PAUSED)));
        }
        this.messageManager.send(request2, (RequestCallback<Object>)((RequestCallback)callback));
    }

    public final void processIncomingJson(@NotNull JsonReaderEx reader) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        reader.beginObject();
        String actor = null;
        JsonReaderEx subReader = null;
        String nextName = null;
        String error = null;
        String errorMessage = null;
        String type = null;
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (Intrinsics.areEqual((Object)name, (Object)"error")) {
                error = reader.nextString();
                continue;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"from")) {
                actor = reader.nextString();
                if (subReader == null) continue;
                String string = actor;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"actor");
                this.handleResponseOrEvent(subReader, nextName, string, error, errorMessage, type);
                return;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"message")) {
                errorMessage = reader.nextString();
                continue;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"type")) {
                type = reader.nextString();
                continue;
            }
            if (actor == null) {
                if (subReader == null) {
                    nextName = name;
                    subReader = reader.subReader();
                }
                reader.skipValue();
                continue;
            }
            this.handleResponseOrEvent(reader, name, actor, error, errorMessage, type);
            return;
        }
        String string = null;
        String string2 = actor;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        this.handleResponseOrEvent(reader, string, string2, error, errorMessage, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void handleResponseOrEvent(JsonReaderEx reader, String nextName, String actor, String error, String errorDescription, String type) {
        nextName = nextName;
        if (Intrinsics.areEqual((Object)"newGlobal", (Object)type)) {
            return;
        }
        var8_8 = new Ref.ObjectRef();
        var8_8.element = null;
        var9_9 = new Ref.ObjectRef();
        var9_9.element = null;
        var10_10 = this.messageManager.getActorToCurrentItem();
        synchronized (lock$iv) {
            block55: {
                block54: {
                    item.element = (RequestItem)this.messageManager.getActorToCurrentItem().remove((Object)actor);
                    if ((RequestItem)item.element != null) break block54;
                    nextRequest.element = null;
                    v0 /* !! */  = Unit.INSTANCE;
                    break block55;
                }
                if (type == null) ** GOTO lbl-1000
                v1 = (RequestItem)item.element;
                if (v1 == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)type, (Object)v1.getMethod().getUglyProtocolResponseType()) ^ true) {
                    this.messageManager.getActorToCurrentItem().put((Object)actor, (Object)((RequestItem)item.element));
                    item.element = null;
                    nextRequest.element = null;
                    v0 /* !! */  = Unit.INSTANCE;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = (RequestItem)item.element;
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((next = v2.getNext()) == null) {
                        nextRequest.element = null;
                        v0 /* !! */  = Unit.INSTANCE;
                    } else {
                        nextRequest.element = next.getMessage();
                        var12_13 = (FirefoxRequest)nextRequest.element != null;
                        if (_Assertions.ENABLED) {
                            if (value$iv == false) {
                                message$iv$iv = "Assertion failed";
                                throw (Throwable)new AssertionError((Object)message$iv$iv);
                            }
                            v3 = Unit.INSTANCE;
                        } else {
                            v3 = Unit.INSTANCE;
                        }
                        next.setMessage(null);
                        v0 /* !! */  = this.messageManager.getActorToCurrentItem().put((Object)actor, (Object)next);
                    }
                }
            }
            var17_16 = v0 /* !! */ ;
        }
        if ((RequestItem)item.element == null) {
            v4 = type;
            if (v4 == null) {
                Intrinsics.throwNpe();
            }
            this.handleEvent(reader, nextName, actor, v4);
            return;
        }
        try {
            if (error == null) {
                v5 = (RequestItem)item.element;
                if (v5 == null) {
                    Intrinsics.throwNpe();
                }
                method = v5.getMethod();
                block5 : switch (FirefoxCommandProcessor$WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        if (Intrinsics.areEqual((Object)"exited", (Object)type)) {
                            v6 = (RequestItem)item.element;
                            if (v6 == null) {
                                Intrinsics.throwNpe();
                            }
                            v6.getCallback().onError("EXITED");
                            return;
                        }
                        if (Intrinsics.areEqual((Object)method, (Object)FirefoxRequest.Method.ATTACH_TO_TAB)) {
                            v7 = com.jetbrains.firefox.FirefoxCommandProcessor$Companion.access$getREADER$p(FirefoxCommandProcessor.Companion).readAttachToTabResult(reader, nextName);
                            v8 = v7;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"READER.readAttachToTabResult(reader, nextName)");
                        } else {
                            v9 = com.jetbrains.firefox.FirefoxCommandProcessor$Companion.access$getREADER$p(FirefoxCommandProcessor.Companion).readThreadInterrupted(reader, nextName);
                            v8 = v9;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"READER.readThreadInterrupted(reader, nextName)");
                        }
                        response = v8;
                        break;
                    }
                    case 4: {
                        this.threadToState.put(actor, ThreadState.RUNNING);
                        response = null;
                        break;
                    }
                    case 5: {
                        response = com.jetbrains.firefox.FirefoxCommandProcessor$Companion.access$getREADER$p(FirefoxCommandProcessor.Companion).readSetBreakpointResult(reader, nextName);
                        break;
                    }
                    case 6: {
                        response = com.jetbrains.firefox.FirefoxCommandProcessor$Companion.access$getREADER$p(FirefoxCommandProcessor.Companion).readSourcesResult(reader, nextName);
                        break;
                    }
                    case 7: {
                        response = com.jetbrains.firefox.FirefoxCommandProcessor$Companion.access$getREADER$p(FirefoxCommandProcessor.Companion).readSourceResult(reader, nextName);
                        break;
                    }
                    case 8: {
                        response = com.jetbrains.firefox.FirefoxCommandProcessor$Companion.access$getREADER$p(FirefoxCommandProcessor.Companion).readFramesResult(reader, nextName);
                        break;
                    }
                    case 9: {
                        response = com.jetbrains.firefox.FirefoxCommandProcessor$Companion.access$getREADER$p(FirefoxCommandProcessor.Companion).readPrototypeAndPropertiesResult(reader, nextName);
                        break;
                    }
                    case 10: {
                        response = reader.hasNext() != false ? com.jetbrains.firefox.FirefoxCommandProcessor$Companion.access$getREADER$p(FirefoxCommandProcessor.Companion).readPropertyResult(reader, nextName) : (PropertyResult)null;
                        break;
                    }
                    case 11: {
                        response = reader.hasNext() != false ? com.jetbrains.firefox.FirefoxCommandProcessor$Companion.access$getREADER$p(FirefoxCommandProcessor.Companion).readPrototypeResult(reader, nextName) : (PrototypeResult)null;
                        break;
                    }
                    case 12: {
                        if (nextName == null) {
                            nextName = reader.nextName();
                        }
                        response = null;
                        do {
                            if (Intrinsics.areEqual((Object)nextName, (Object)"bindings")) {
                                response = com.jetbrains.firefox.FirefoxCommandProcessor$Companion.access$getREADER$p(FirefoxCommandProcessor.Companion).readBindings(reader, null);
                                break block5;
                            }
                            reader.skipValue();
                            nextName = reader.nextName();
                        } while (reader.hasNext());
                        break;
                    }
                    case 13: {
                        response = com.jetbrains.firefox.FirefoxCommandProcessor$Companion.access$getREADER$p(FirefoxCommandProcessor.Companion).readListTabsResult(reader, nextName);
                        break;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: {
                        response = null;
                        break;
                    }
                    default: {
                        rejectError = "Unknown response " + method.getProtocolName() + ", actor " + actor;
                        CommandProcessorKt.getLOG().error(rejectError);
                        v10 = (RequestItem)item.element;
                        if (v10 == null) {
                            Intrinsics.throwNpe();
                        }
                        v10.getCallback().onError(rejectError);
                        return;
                    }
                }
                v11 = (RequestItem)item.element;
                if (v11 == null) {
                    Intrinsics.throwNpe();
                }
                v11.getCallback().onSuccess(response, (ResultReader)null);
            } else {
                v12 = (RequestItem)item.element;
                if (v12 == null) {
                    Intrinsics.throwNpe();
                }
                if (v12.getMethod() == FirefoxRequest.Method.RELEASE_MANY && Intrinsics.areEqual((Object)error, (Object)"notReleasable")) {
                    v13 = (RequestItem)item.element;
                    if (v13 == null) {
                        Intrinsics.throwNpe();
                    }
                    v13.getCallback().onSuccess(null, (ResultReader)null);
                } else {
                    v14 = (RequestItem)item.element;
                    if (v14 == null) {
                        Intrinsics.throwNpe();
                    }
                    v14.getCallback().onError(error + (errorDescription == null ? "" : ", " + errorDescription));
                }
            }
        }
        finally {
            if ((FirefoxRequest)nextRequest.element != null) {
                v15 = (FirefoxRequest)nextRequest.element;
                if (v15 == null) {
                    Intrinsics.throwNpe();
                }
                this.writer.invoke((Object)CommandProcessorKt.requestToByteBuf$default((Request)v15, (boolean)false, (int)2, null));
            }
        }
        item = null;
        nextRequest = null;
    }

    private final void handleEvent(JsonReaderEx reader, String nextName, String actor, String type) {
        IFirefoxListener multicaster = (IFirefoxListener)this.dispatcher.getMulticaster();
        if (Intrinsics.areEqual((Object)type, (Object)"tabDetached")) {
            multicaster.tabDetached(actor);
        } else if (Intrinsics.areEqual((Object)type, (Object)"paused")) {
            this.threadToState.put(actor, ThreadState.PAUSED);
            ThreadInterrupted threadInterrupted = FirefoxCommandProcessor.Companion.getREADER().readThreadInterrupted(reader, nextName);
            Intrinsics.checkExpressionValueIsNotNull((Object)threadInterrupted, (String)"READER.readThreadInterrupted(reader, nextName)");
            multicaster.paused(threadInterrupted);
        } else if (Intrinsics.areEqual((Object)type, (Object)"frameUpdate")) {
            String name = nextName;
            if (name == null && reader.hasNext()) {
                name = reader.nextName();
            }
            boolean destroyAll = false;
            if (name != null) {
                do {
                    if (Intrinsics.areEqual((Object)name, (Object)"destroyAll")) {
                        destroyAll = reader.nextBoolean();
                        break;
                    }
                    reader.skipValue();
                    if (reader.nextNameOrNull() != null) continue;
                    break;
                } while (true);
            }
            multicaster.frameUpdated(actor, destroyAll);
        } else if (Intrinsics.areEqual((Object)type, (Object)"newSource")) {
            String name = nextName;
            if (name == null) {
                name = reader.nextName();
            }
            do {
                if (Intrinsics.areEqual((Object)name, (Object)"source")) {
                    Source source = FirefoxCommandProcessor.Companion.getREADER().readSource(reader, null);
                    Intrinsics.checkExpressionValueIsNotNull((Object)source, (String)"READER.readSource(reader, null)");
                    multicaster.scriptAdded(source);
                } else {
                    reader.skipValue();
                    if (reader.nextNameOrNull() != null) continue;
                }
                break;
            } while (true);
        } else if (!Intrinsics.areEqual((Object)type, (Object)"tabNavigated") && !Intrinsics.areEqual((Object)type, (Object)"tabListChanged")) {
            CommandProcessorKt.getLOG().warn("Unhandled event " + actor + ":" + type);
        }
    }

    public final void clear() {
        this.messageManager.clear$FirefoxConnector();
        for (String key : this.threadToState.keySet()) {
            this.threadToState.put(key, ThreadState.RUNNING);
        }
    }

    public FirefoxCommandProcessor(@NotNull Function1<? super ByteBuf, Boolean> writer) {
        Intrinsics.checkParameterIsNotNull(writer, (String)"writer");
        this.writer = writer;
        this.messageManager = new FirefoxMessageManager();
        this.threadToState = ContainerUtil.newConcurrentMap();
        this.dispatcher = EventDispatcher.create(IFirefoxListener.class);
    }

    static {
        Companion = new Companion(null);
        READER = new FirefoxProtocolReaderImpl();
    }

    @NotNull
    public static final /* synthetic */ FirefoxMessageManager access$getMessageManager$p(FirefoxCommandProcessor $this) {
        return $this.messageManager;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor$IFirefoxListener;", "Ljava/util/EventListener;", "frameUpdated", "", "actor", "", "destroyAll", "", "paused", "event", "Lcom/jetbrains/firefox/rdp/ThreadInterrupted;", "scriptAdded", "script", "Lcom/jetbrains/firefox/rdp/Source;", "tabDetached", "FirefoxConnector"})
    public static interface IFirefoxListener
    extends EventListener {
        public void tabDetached(@NotNull String var1);

        public void paused(@NotNull ThreadInterrupted var1);

        public void frameUpdated(@NotNull String var1, boolean var2);

        public void scriptAdded(@NotNull Source var1);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor$ThreadState;", "", "(Ljava/lang/String;I)V", "PAUSED", "RUNNING", "FirefoxConnector"})
    public static final class ThreadState
    extends Enum<ThreadState> {
        public static final /* enum */ ThreadState PAUSED;
        public static final /* enum */ ThreadState RUNNING;
        private static final /* synthetic */ ThreadState[] $VALUES;

        static {
            ThreadState[] threadStateArray = new ThreadState[2];
            ThreadState[] threadStateArray2 = threadStateArray;
            threadStateArray[0] = PAUSED = new ThreadState();
            threadStateArray[1] = RUNNING = new ThreadState();
            $VALUES = threadStateArray;
        }

        public static ThreadState[] values() {
            return (ThreadState[])$VALUES.clone();
        }

        public static ThreadState valueOf(String string) {
            return Enum.valueOf(ThreadState.class, string);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor$RequestItem;", "", "message", "Lcom/jetbrains/firefox/FirefoxRequest;", "method", "Lcom/jetbrains/firefox/FirefoxRequest$Method;", "callback", "Lorg/jetbrains/rpc/RequestCallback;", "(Lcom/jetbrains/firefox/FirefoxRequest;Lcom/jetbrains/firefox/FirefoxRequest$Method;Lorg/jetbrains/rpc/RequestCallback;)V", "getCallback", "()Lorg/jetbrains/rpc/RequestCallback;", "getMessage", "()Lcom/jetbrains/firefox/FirefoxRequest;", "setMessage", "(Lcom/jetbrains/firefox/FirefoxRequest;)V", "getMethod", "()Lcom/jetbrains/firefox/FirefoxRequest$Method;", "next", "getNext", "()Lcom/jetbrains/firefox/FirefoxCommandProcessor$RequestItem;", "setNext", "(Lcom/jetbrains/firefox/FirefoxCommandProcessor$RequestItem;)V", "FirefoxConnector"})
    private static final class RequestItem {
        @Nullable
        private RequestItem next;
        @Nullable
        private FirefoxRequest<Object> message;
        @NotNull
        private final FirefoxRequest.Method method;
        @NotNull
        private final RequestCallback<Object> callback;

        @Nullable
        public final RequestItem getNext() {
            return this.next;
        }

        public final void setNext(@Nullable RequestItem requestItem) {
            this.next = requestItem;
        }

        @Nullable
        public final FirefoxRequest<Object> getMessage() {
            return this.message;
        }

        public final void setMessage(@Nullable FirefoxRequest<Object> firefoxRequest) {
            this.message = firefoxRequest;
        }

        @NotNull
        public final FirefoxRequest.Method getMethod() {
            return this.method;
        }

        @NotNull
        public final RequestCallback<Object> getCallback() {
            return this.callback;
        }

        public RequestItem(@Nullable FirefoxRequest<Object> message, @NotNull FirefoxRequest.Method method, @NotNull RequestCallback<Object> callback) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)method), (String)"method");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.message = message;
            this.method = method;
            this.callback = callback;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\r\u0010\u000b\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\fJ\"\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor$FirefoxMessageManager;", "Lorg/jetbrains/rpc/MessageManagerBase;", "(Lcom/jetbrains/firefox/FirefoxCommandProcessor;)V", "actorToCurrentItem", "Lgnu/trove/THashMap;", "", "Lcom/jetbrains/firefox/FirefoxCommandProcessor$RequestItem;", "getActorToCurrentItem", "()Lgnu/trove/THashMap;", "cancelWaitingRequests", "", "clear", "clear$FirefoxConnector", "send", "message", "Lcom/jetbrains/firefox/FirefoxRequest;", "", "callback", "Lorg/jetbrains/rpc/RequestCallback;", "FirefoxConnector"})
    private final class FirefoxMessageManager
    extends MessageManagerBase {
        @NotNull
        private final THashMap<String, RequestItem> actorToCurrentItem = new THashMap();

        @NotNull
        public final THashMap<String, RequestItem> getActorToCurrentItem() {
            return this.actorToCurrentItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void send(@NotNull FirefoxRequest<Object> message, @NotNull RequestCallback<Object> callback) {
            void lock$iv;
            Intrinsics.checkParameterIsNotNull(message, (String)"message");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            if (this.rejectIfClosed(callback)) {
                return;
            }
            message.finalize(-1);
            String actor = message.getActor();
            THashMap<String, RequestItem> tHashMap = this.actorToCurrentItem;
            synchronized (lock$iv) {
                RequestItem item = (RequestItem)this.actorToCurrentItem.get((Object)actor);
                if (item != null) {
                    RequestItem prev = item;
                    while (prev.getNext() != null) {
                        if (prev.getNext() != null) continue;
                        Intrinsics.throwNpe();
                    }
                    prev.setNext(new RequestItem(message, message.getMethod(), callback));
                    return;
                }
                RequestItem requestItem = (RequestItem)this.actorToCurrentItem.put((Object)actor, (Object)new RequestItem(null, message.getMethod(), callback));
            }
            FirefoxCommandProcessor.this.writer.invoke((Object)CommandProcessorKt.requestToByteBuf$default((Request)message, (boolean)false, (int)2, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clear$FirefoxConnector() {
            THashMap<String, RequestItem> lock$iv = this.actorToCurrentItem;
            synchronized (lock$iv) {
                this.cancelWaitingRequests();
                this.actorToCurrentItem.clear();
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void cancelWaitingRequests() {
            THashMap<String, RequestItem> lock$iv = this.actorToCurrentItem;
            synchronized (lock$iv) {
                Iterator iterator = this.actorToCurrentItem.values().iterator();
                block3: while (iterator.hasNext()) {
                    RequestItem listItem;
                    RequestItem item = listItem = (RequestItem)iterator.next();
                    do {
                        item.setMessage(null);
                        MessageManagerBaseKt.reject(item.getCallback());
                        if (item.getNext() != null) continue;
                        continue block3;
                    } while (true);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/jetbrains/firefox/FirefoxCommandProcessor$Companion;", "", "()V", "READER", "Lcom/jetbrains/firefox/rdp/FirefoxProtocolReaderImpl;", "getREADER", "()Lcom/jetbrains/firefox/rdp/FirefoxProtocolReaderImpl;", "write", "Lio/netty/channel/ChannelFuture;", "contentBuffer", "Lio/netty/buffer/ByteBuf;", "channel", "Lio/netty/channel/Channel;", "FirefoxConnector"})
    public static final class Companion {
        private final FirefoxProtocolReaderImpl getREADER() {
            return READER;
        }

        @NotNull
        public final ChannelFuture write(@NotNull ByteBuf contentBuffer, @NotNull Channel channel) {
            Intrinsics.checkParameterIsNotNull((Object)contentBuffer, (String)"contentBuffer");
            Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
            ByteBuf lengthBuffer = channel.alloc().ioBuffer(8);
            ChannelBufferToString.writeIntAsAscii((int)contentBuffer.readableBytes(), (ByteBuf)lengthBuffer);
            lengthBuffer.writeByte(58);
            channel.write((Object)lengthBuffer);
            ChannelFuture channelFuture = channel.writeAndFlush((Object)contentBuffer);
            Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"channel.writeAndFlush(contentBuffer)");
            return channelFuture;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

