/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.debugger.impl.DebuggableFileFinder;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.firefox.FirefoxDebugProcess;
import com.jetbrains.firefox.FirefoxRemoteVmConnection;
import com.jetbrains.javascript.debugger.DebuggableFileFinderImpl;
import java.net.InetSocketAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.RemoteDebugConfiguration;
import org.jetbrains.debugger.connection.VmConnection;

final class FirefoxRemoteDebugConfiguration
extends RemoteDebugConfiguration {
    public FirefoxRemoteDebugConfiguration(Project project, @NotNull ConfigurationFactory factory, String name) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/jetbrains/firefox/FirefoxRemoteDebugConfiguration", "<init>"));
        }
        super(project, factory, name, 6000);
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        if (socketAddress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "socketAddress", "com/jetbrains/firefox/FirefoxRemoteDebugConfiguration", "createDebugProcess"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/firefox/FirefoxRemoteDebugConfiguration", "createDebugProcess"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/firefox/FirefoxRemoteDebugConfiguration", "createDebugProcess"));
        }
        FirefoxRemoteVmConnection connection = new FirefoxRemoteVmConnection();
        DebuggableFileFinderImpl fileFinder = new DebuggableFileFinderImpl(session.getProject(), null);
        FirefoxDebugProcess process = new FirefoxDebugProcess(session, (DebuggableFileFinder)fileFinder, (VmConnection<?>)connection, executionResult);
        connection.open(socketAddress, null);
        FirefoxDebugProcess firefoxDebugProcess = process;
        if (firefoxDebugProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/firefox/FirefoxRemoteDebugConfiguration", "createDebugProcess"));
        }
        return firefoxDebugProcess;
    }
}

