/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.util.Function;
import com.jetbrains.firefox.FirefoxCallFrame;
import com.jetbrains.firefox.FirefoxCommandProcessor;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.FirefoxSuspendContext;
import com.jetbrains.firefox.FirefoxValueManager;
import com.jetbrains.firefox.FirefoxVm;
import com.jetbrains.firefox.rdp.Frame;
import com.jetbrains.firefox.rdp.FramesResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseManager;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a-\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\u0010\u000b\" \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"CALL_FRAMES_LOADER", "Lorg/jetbrains/concurrency/PromiseManager;", "Lcom/jetbrains/firefox/FirefoxSuspendContext;", "", "Lcom/jetbrains/firefox/FirefoxCallFrame;", "createFrames", "result", "Lcom/jetbrains/firefox/rdp/FramesResult;", "topFrame", "valueManager", "Lcom/jetbrains/firefox/FirefoxValueManager;", "(Lcom/jetbrains/firefox/rdp/FramesResult;Lcom/jetbrains/firefox/FirefoxCallFrame;Lcom/jetbrains/firefox/FirefoxValueManager;)[Lcom/jetbrains/firefox/FirefoxCallFrame;", "FirefoxConnector"})
public final class FirefoxSuspendContextKt {
    private static final PromiseManager<FirefoxSuspendContext, FirefoxCallFrame[]> CALL_FRAMES_LOADER = (PromiseManager)new PromiseManager<FirefoxSuspendContext, FirefoxCallFrame[]>(FirefoxSuspendContext.class){

        @NotNull
        public Promise<FirefoxCallFrame[]> load(@NotNull FirefoxSuspendContext context) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)context), (String)"context");
            FirefoxVm vm = (FirefoxVm)((FirefoxValueManager)context.getValueManager()).getVm();
            FirefoxCommandProcessor firefoxCommandProcessor = vm.getCommandProcessor();
            String string = vm.getThreadActor();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Promise promise = firefoxCommandProcessor.send(FirefoxRequest.Companion.getFrames(string, 1)).then((Function)new Function<? super T, ? extends SUB_RESULT>(context){
                final /* synthetic */ FirefoxSuspendContext $context;

                @NotNull
                public final FirefoxCallFrame[] fun(FramesResult it) {
                    FramesResult framesResult = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)framesResult, (String)"it");
                    return FirefoxSuspendContextKt.createFrames(framesResult, this.$context.getTopFrame(), (FirefoxValueManager)this.$context.getValueManager());
                }
                {
                    this.$context = firefoxSuspendContext;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"vm.commandProcessor.send\u2026, context.valueManager) }");
            return promise;
        }
    };

    @NotNull
    public static final FirefoxCallFrame[] createFrames(@NotNull FramesResult result, @Nullable FirefoxCallFrame topFrame, @NotNull FirefoxValueManager valueManager) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)((Object)valueManager), (String)"valueManager");
        int offset = topFrame == null ? 0 : 1;
        FirefoxCallFrame[] frames = new FirefoxCallFrame[result.frames().size() + offset];
        if (topFrame != null) {
            frames[0] = topFrame;
        }
        List<Frame> vmFrames = result.frames();
        boolean useBindingsFromFrameData = topFrame == null;
        int n = vmFrames.size();
        for (int i = 0; i < n; ++i) {
            frames[i + offset] = new FirefoxCallFrame(valueManager, vmFrames.get(i), useBindingsFromFrameData);
            useBindingsFromFrameData = false;
        }
        return frames;
    }

    @NotNull
    public static final /* synthetic */ PromiseManager access$getCALL_FRAMES_LOADER$p() {
        return CALL_FRAMES_LOADER;
    }
}

