/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopElementBase;
import com.intellij.aop.psi.AopParameterList;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.AopReferenceTarget;
import com.intellij.aop.psi.PointcutContext;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiArgsExpression
extends AopElementBase
implements PsiPointcutExpression {
    private static final AopParameterList.TypeArgumentMatcher ARGS_MATCHER = new AopParameterList.TypeArgumentMatcher(){

        @Override
        public PointcutMatchDegree matches(PsiParameter psiParameter, AopReferenceTarget target) {
            PsiType actualType = psiParameter.getType();
            if (target.accepts(actualType) == PointcutMatchDegree.TRUE || target.isAssignableFrom(actualType)) {
                return PointcutMatchDegree.TRUE;
            }
            String typeText = target.getQualifiedName();
            PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType((String)typeText);
            if (primitiveType != null && !(actualType instanceof PsiPrimitiveType)) {
                if (primitiveType == PsiPrimitiveType.getUnboxedType((PsiType)actualType)) {
                    return PointcutMatchDegree.TRUE;
                }
            } else if (actualType instanceof PsiPrimitiveType) {
                return PointcutMatchDegree.valueOf(Comparing.equal((String)((PsiPrimitiveType)actualType).getBoxedTypeName(), (String)typeText) || "java.lang.Number".equals(typeText) || "java.lang.Object".equals(typeText));
            }
            return PointcutMatchDegree.FALSE;
        }
    };

    public PsiArgsExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/aop/psi/PsiArgsExpression", "<init>"));
        }
        super(node);
    }

    public String toString() {
        return "PsiArgsExpression";
    }

    @Nullable
    public AopParameterList getParameterList() {
        return (AopParameterList)((Object)this.findChildByClass(AopParameterList.class));
    }

    @Override
    @NotNull
    public PointcutMatchDegree acceptsSubject(PointcutContext context, PsiMember member) {
        if (member instanceof PsiMethod) {
            AopParameterList parameterList = this.getParameterList();
            PointcutMatchDegree pointcutMatchDegree = parameterList != null ? parameterList.matches(context, ((PsiMethod)member).getParameterList(), ARGS_MATCHER) : PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiArgsExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
        if (pointcutMatchDegree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiArgsExpression", "acceptsSubject"));
        }
        return pointcutMatchDegree;
    }

    @Override
    @NotNull
    public Collection<AopPsiTypePattern> getPatterns() {
        List<AopPsiTypePattern> list = Arrays.asList(AopPsiTypePattern.TRUE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiArgsExpression", "getPatterns"));
        }
        return list;
    }
}

