/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less;

import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;
import org.jetbrains.plugins.less.psi.impl.LESSRegularMixin;
import org.jetbrains.plugins.less.psi.stubs.LessMixinIndex;
import org.jetbrains.plugins.less.psi.stubs.LessVariableIndex;

public class LessGotoSymbolContributor
implements ChooseByNameContributorEx {
    public void processNames(final @NotNull Processor<String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/less/LessGotoSymbolContributor", "processNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/less/LessGotoSymbolContributor", "processNames"));
        }
        StubIndex.getInstance().processAllKeys(LessMixinIndex.KEY, (Processor)new Processor<String>(){

            public boolean process(String name) {
                if (processor.process((Object)name) && (StringUtil.startsWithChar((CharSequence)name, (char)'.') || StringUtil.startsWithChar((CharSequence)name, (char)'#'))) {
                    return processor.process((Object)name.substring(1));
                }
                return false;
            }
        }, scope, filter);
        StubIndex.getInstance().processAllKeys(LessVariableIndex.KEY, (Processor)new Processor<String>(){

            public boolean process(String s) {
                return processor.process((Object)s) && processor.process((Object)("@" + s));
            }
        }, scope, filter);
    }

    public void processElementsWithName(@NotNull String name, final @NotNull Processor<NavigationItem> processor, @NotNull FindSymbolParameters parameters) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/less/LessGotoSymbolContributor", "processElementsWithName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/less/LessGotoSymbolContributor", "processElementsWithName"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/less/LessGotoSymbolContributor", "processElementsWithName"));
        }
        Processor<LESSMixin> mixinProcessor = new Processor<LESSMixin>(){

            public boolean process(LESSMixin mixin) {
                return !(mixin instanceof LESSRegularMixin) || processor.process((Object)mixin);
            }
        };
        Processor<LESSVariableDeclaration> variableProcessor = new Processor<LESSVariableDeclaration>(){

            public boolean process(LESSVariableDeclaration variableDeclaration) {
                return !variableDeclaration.isGlobal() || processor.process((Object)variableDeclaration);
            }
        };
        if (StringUtil.startsWithChar((CharSequence)name, (char)'.') || StringUtil.startsWithChar((CharSequence)name, (char)'#')) {
            LessMixinIndex.process(name, parameters.getProject(), parameters.getSearchScope(), (Processor<? super LESSMixin>)mixinProcessor);
        } else if (StringUtil.startsWithChar((CharSequence)name, (char)'@')) {
            LessVariableIndex.process(name.substring(1), parameters.getProject(), parameters.getSearchScope(), (Processor<? super LESSVariableDeclaration>)variableProcessor);
        } else {
            LessMixinIndex.process("." + name, parameters.getProject(), parameters.getSearchScope(), (Processor<? super LESSMixin>)mixinProcessor);
            LessMixinIndex.process("#" + name, parameters.getProject(), parameters.getSearchScope(), (Processor<? super LESSMixin>)mixinProcessor);
            LessVariableIndex.process(name, parameters.getProject(), parameters.getSearchScope(), (Processor<? super LESSVariableDeclaration>)variableProcessor);
        }
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        if (NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/LessGotoSymbolContributor", "getItemsByName"));
        }
        return NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY;
    }

    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/LessGotoSymbolContributor", "getNames"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }
}

