/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.LESSUtil;
import org.jetbrains.plugins.less.LessLangUtil;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;
import org.jetbrains.plugins.less.psi.LessParameter;
import org.jetbrains.plugins.less.psi.stubs.LessVariableIndex;

public class LessVariableCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/less/completion/provider/LessVariableCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/less/completion/provider/LessVariableCompletionProvider", "addCompletions"));
        }
        String prefix = result.getPrefixMatcher().getPrefix();
        final CompletionResultSet resultSet = prefix.startsWith("@{") ? result.withPrefixMatcher(prefix.substring(2)) : result;
        final PsiElement position = parameters.getPosition();
        Project project = position.getProject();
        final LESSVariableDeclaration originalParentDeclaration = LessVariableCompletionProvider.getParentVariableDeclaration(position);
        final Set importedFiles = CssUtil.getImportedFiles((PsiFile)parameters.getOriginalFile(), (PsiElement)position, (boolean)false);
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)position);
        for (String name : StubIndex.getInstance().getAllKeys(LessVariableIndex.KEY, project)) {
            LessVariableIndex.process(name, project, scope, (Processor<? super LESSVariableDeclaration>)new Processor<LESSVariableDeclaration>(){

                public boolean process(LESSVariableDeclaration variableDeclaration) {
                    if (originalParentDeclaration == variableDeclaration || position.getParent() == variableDeclaration) {
                        return true;
                    }
                    if (LessLangUtil.isVisibleDeclaration((PsiElement)variableDeclaration, position)) {
                        boolean validResult = importedFiles.contains(variableDeclaration.getContainingFile().getVirtualFile());
                        resultSet.addElement(LESSUtil.createVariableLookupItem(variableDeclaration, validResult));
                    }
                    return true;
                }
            });
        }
        LessVariableCompletionProvider.addParametersVariableVariant(resultSet, position);
    }

    private static void addParametersVariableVariant(@NotNull CompletionResultSet result, @NotNull PsiElement position) {
        LESSMixin lessMixin;
        LESSMixin closestMixin;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/less/completion/provider/LessVariableCompletionProvider", "addParametersVariableVariant"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/less/completion/provider/LessVariableCompletionProvider", "addParametersVariableVariant"));
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)position, LessParameter.class) != null && (closestMixin = (LESSMixin)PsiTreeUtil.getParentOfType((PsiElement)position, LESSMixin.class)) != null) {
            position = closestMixin;
        }
        if ((lessMixin = (LESSMixin)PsiTreeUtil.getParentOfType((PsiElement)position, LESSMixin.class)) != null && lessMixin.hasParameters()) {
            result.addElement(LESSUtil.createArgumentsLookupItem(lessMixin));
        }
    }

    @Nullable
    private static LESSVariableDeclaration getParentVariableDeclaration(PsiElement variable) {
        LESSVariableDeclaration parentDeclaration = (LESSVariableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)variable, LESSVariableDeclaration.class);
        return parentDeclaration != null ? (LESSVariableDeclaration)CompletionUtil.getOriginalElement((PsiElement)parentDeclaration) : null;
    }
}

