/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.include;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.include.AbstractCssFileIncludeProvider;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSFileType;
import org.jetbrains.plugins.less.LESSLanguage;

public class LessFileIncludeProvider
extends AbstractCssFileIncludeProvider {
    @NotNull
    public String getId() {
        String string = LESSLanguage.INSTANCE.getID();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/include/LessFileIncludeProvider", "getId"));
        }
        return string;
    }

    public boolean acceptFile(VirtualFile file) {
        return file.isInLocalFileSystem() && file.getFileType() == LESSFileType.LESS;
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "org/jetbrains/plugins/less/include/LessFileIncludeProvider", "registerFileTypesUsedForIndexing"));
        }
        fileTypeSink.consume((Object)LESSFileType.LESS);
    }

    protected void addImports(@NotNull List<FileIncludeInfo> result, @NotNull VirtualFile hostFile, @NotNull String hostFileExt, @NotNull String importUri, @NotNull String importUriExt) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/less/include/LessFileIncludeProvider", "addImports"));
        }
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "org/jetbrains/plugins/less/include/LessFileIncludeProvider", "addImports"));
        }
        if (hostFileExt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFileExt", "org/jetbrains/plugins/less/include/LessFileIncludeProvider", "addImports"));
        }
        if (importUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importUri", "org/jetbrains/plugins/less/include/LessFileIncludeProvider", "addImports"));
        }
        if (importUriExt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importUriExt", "org/jetbrains/plugins/less/include/LessFileIncludeProvider", "addImports"));
        }
        boolean addExtension = !importUriExt.equalsIgnoreCase("css") && !importUriExt.equalsIgnoreCase(hostFileExt);
        result.add(new FileIncludeInfo(addExtension ? importUri + "." + hostFileExt : importUri));
    }
}

