/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.lexer;

import com.intellij.ide.highlighter.custom.tokens.TokenInfo;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighterLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.lexer.LESSLexer;
import org.jetbrains.plugins.less.lexer.LESSTokenTypes;

public class LESSHighlightingLexer
extends CssHighlighterLexer {
    private static final int IN_DECLARATION_FLAG = 16;
    private static final int AFTER_AMPERSAND_FLAG = 32;
    private static final int BLOCK_LEVEL_MASK = 15;
    private static final TokenSet END_DECLARATION_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_SEMICOLON, CssElementTypes.CSS_RBRACE});
    private int blockNestingDepth;
    private boolean inVariableDeclaration;
    private boolean afterAmpersand;

    public LESSHighlightingLexer(@NotNull Set<String> propertyValues) {
        if (propertyValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyValues", "org/jetbrains/plugins/less/lexer/LESSHighlightingLexer", "<init>"));
        }
        super((Lexer)new LESSLexer(), propertyValues);
        this.blockNestingDepth = 0;
        this.inVariableDeclaration = false;
        this.afterAmpersand = false;
    }

    public void advance() {
        IElementType type = this.getTokenType();
        if (type == CssElementTypes.CSS_LBRACE && !this.myAfterKeyframes) {
            ++this.blockNestingDepth;
        }
        if (type == CssElementTypes.CSS_RBRACE && !this.myInKeyframes && this.blockNestingDepth > 0) {
            --this.blockNestingDepth;
        }
        this.afterAmpersand = LESSTokenTypes.AMPERSAND == type;
        super.advance();
        this.myInsideBlock = this.blockNestingDepth > 0;
    }

    protected void initState(int initialState) {
        super.initState(initialState);
        int state = initialState >> 20;
        this.inVariableDeclaration = (state & 0x10) != 0;
        this.afterAmpersand = (state & 0x20) != 0;
        this.blockNestingDepth = state & 0xF;
    }

    protected boolean isAndOrIdentifier(IElementType type, String tokenText) {
        return type == LESSTokenTypes.AND_KEYWORD || type == LESSTokenTypes.OR_KEYWORD;
    }

    public int getState() {
        int state = 0;
        state |= this.inVariableDeclaration ? 16 : 0;
        state |= this.afterAmpersand ? 32 : 0;
        return super.getState() | (state |= this.blockNestingDepth <= 15 ? this.blockNestingDepth : 15) << 20;
    }

    public IElementType getTokenType() {
        IElementType tokenType = super.getTokenType();
        if (this.getDelegate().getTokenType() == LESSTokenTypes.INTERPOLATION_PREFIX) {
            return LESSTokenTypes.INTERPOLATION_PREFIX;
        }
        if (tokenType == LESSTokenTypes.VARIABLE) {
            this.myInPropertyValue = true;
            this.inVariableDeclaration = true;
        } else if (tokenType == CssElementTypes.CSS_SEMICOLON) {
            this.inVariableDeclaration = false;
        } else {
            if ((tokenType == CssElementTypes.CSS_IDENT || tokenType == CssElementTypes.CSS_HASH) && this.lookAhead(1).getType() == CssElementTypes.CSS_LPAREN) {
                return CssElementTypes.CSS_FUNCTION_TOKEN;
            }
            if (tokenType == LESSTokenTypes.IMPORT_ONCE_SYM || tokenType == LESSTokenTypes.PLUGIN_SYM) {
                return CssElementTypes.CSS_KEYWORD;
            }
        }
        return tokenType;
    }

    public boolean isPropertyNameAllowed() {
        boolean detachedRuleset = (this.myAfterLeftBrace || this.myAfterSemicolon) && this.myFunctionNestingDepth > 0;
        return !this.afterAmpersand && (super.isPropertyNameAllowed() || detachedRuleset) && this.lookAhead(1).getType() == CssElementTypes.CSS_COLON;
    }

    public boolean isPropertyValueAllowed() {
        return !(!this.myInPropertyValue && this.myFunctionNestingDepth <= 0 || !this.myInsideBlock && !this.inVariableDeclaration && !this.myAfterMediaOrSupports || this.myAfterLeftBrace || this.myAfterSemicolon);
    }

    public boolean isSelectorAllowed() {
        TokenInfo nextElement = this.lookAhead(1);
        if (END_DECLARATION_TOKENS.contains(nextElement.getType())) {
            return false;
        }
        if (nextElement.getType() == CssElementTypes.CSS_COLON) {
            TokenInfo nextNextElement = this.lookAhead(2);
            return nextElement.getEnd() == nextNextElement.getStart();
        }
        return !this.myInPropertyValue && this.myFunctionNestingDepth <= 0 && !this.myAfterMediaOrSupports;
    }

    private TokenInfo lookAhead(int steps) {
        LexerPosition currentPosition = this.getDelegate().getCurrentPosition();
        while (steps > 0) {
            this.getDelegate().advance();
            IElementType type = this.getDelegate().getTokenType();
            if (type == null) break;
            if (LESSHighlightingLexer.isWhitespace(type)) continue;
            --steps;
        }
        TokenInfo result = new TokenInfo();
        result.updateData(this.getDelegate().getTokenStart(), this.getDelegate().getTokenEnd(), this.getDelegate().getTokenType());
        this.getDelegate().restore(currentPosition);
        return result;
    }

    private static boolean isWhitespace(IElementType type) {
        return CssElementTypes.WHITESPACES.contains(type);
    }
}

