/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.references;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSUtil;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.impl.LESSMixinName;
import org.jetbrains.plugins.less.psi.stubs.LessMixinIndex;

public class LESSMixinReference
extends PsiPolyVariantReferenceBase<LESSMixinInvocation> {
    public LESSMixinReference(LESSMixinInvocation element) {
        super((PsiElement)element);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)this.myElement);
        final Set importedFiles = CssUtil.getImportedFiles((PsiFile)((LESSMixinInvocation)this.myElement).getContainingFile(), (PsiElement)this.myElement, (boolean)false);
        final LinkedList result = Lists.newLinkedList();
        final LinkedList resultResolvedByNameOnly = Lists.newLinkedList();
        final String invocationNamespace = ((LESSMixinInvocation)this.myElement).getNamespace();
        LessMixinIndex.process(((LESSMixinInvocation)this.myElement).getFullName(), ((LESSMixinInvocation)this.myElement).getProject(), scope, (Processor<? super LESSMixin>)new Processor<LESSMixin>(){

            public boolean process(LESSMixin mixin) {
                if (LESSUtil.isMixinMatchesWithInvocation(mixin, LESSMixinReference.this.myElement, invocationNamespace)) {
                    boolean validResult = importedFiles.contains(mixin.getContainingFile().getVirtualFile());
                    PsiElementResolveResult resolveResult = new PsiElementResolveResult(mixin.getTargetForReference(), validResult);
                    if (validResult) {
                        result.add(resolveResult);
                    } else {
                        resultResolvedByNameOnly.add(resolveResult);
                    }
                }
                return true;
            }
        });
        result.addAll(resultResolvedByNameOnly);
        ResolveResult[] resolveResultArray = result.toArray(new ResolveResult[result.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LESSMixinReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LESSMixinReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    protected TextRange calculateDefaultRangeInElement() {
        LESSMixinName fullNameIdentifier = ((LESSMixinInvocation)this.myElement).getFullNameIdentifier();
        return fullNameIdentifier != null && fullNameIdentifier.getText().length() > 0 ? TextRange.from((int)(fullNameIdentifier.getStartOffsetInParent() + 1), (int)(fullNameIdentifier.getTextLength() - 1)) : TextRange.EMPTY_RANGE;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return ((LESSMixinInvocation)this.myElement).setName(newElementName);
    }
}

