/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.util.UriTemplateParser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.websocket.jam.WebSocketEndpoint;
import com.intellij.websocket.references.WebSocketPathReference;
import com.intellij.websocket.utils.WebSocketCommonUtils;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSocketPathParamReference
extends PsiReferenceBase<PsiLiteralExpression> {
    private PsiLiteralExpression myParam;
    private final String myStringValue;
    private final Pattern GOOD_PATH_NAME = Pattern.compile("[a-zA-Z0-9_-]*");

    public WebSocketPathParamReference(PsiLiteralExpression pathParamLiteral) {
        super((PsiElement)pathParamLiteral, false);
        this.myParam = pathParamLiteral;
        Object value = this.myParam.getValue();
        this.myStringValue = value instanceof String ? (String)value : null;
    }

    public PsiElement resolve() {
        PsiElement element;
        PsiAnnotationMemberValue attributeValue;
        if (this.myStringValue == null) {
            return null;
        }
        PsiAnnotation annotation = WebSocketPathParamReference.findEndpointAnnotation(this.myElement);
        if (annotation != null && (attributeValue = annotation.findAttributeValue("value")) != null && (element = attributeValue.getOriginalElement()) instanceof PsiLiteralExpression) {
            for (PsiReference reference : element.getReferences()) {
                WebSocketPathReference pathReference;
                if (!(reference instanceof WebSocketPathReference) || !this.myStringValue.equals((pathReference = (WebSocketPathReference)reference).getName())) continue;
                return pathReference.resolve();
            }
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findEndpointAnnotation(@NotNull PsiElement element) {
        WebSocketEndpoint endpoint;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/websocket/references/WebSocketPathParamReference", "findEndpointAnnotation"));
        }
        PsiClass endpointClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (endpointClass != null && (endpoint = WebSocketCommonUtils.getWebsocketEndpoint(endpointClass)) != null) {
            return endpoint.getJamAnnotationMeta().getAnnotation((PsiModifierListOwner)endpointClass);
        }
        return null;
    }

    @Nullable
    private static WebSocketEndpoint findEndpoint(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/websocket/references/WebSocketPathParamReference", "findEndpoint"));
        }
        PsiClass endpointClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (endpointClass != null) {
            return WebSocketCommonUtils.getWebsocketEndpoint(endpointClass);
        }
        return null;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (this.GOOD_PATH_NAME.matcher(newElementName).matches()) {
            PsiExpression newLiteral = JavaPsiFacade.getElementFactory((Project)((PsiLiteralExpression)this.getElement()).getProject()).createExpressionFromText("\"" + newElementName + "\"", this.myParam.getContext());
            this.myParam = (PsiLiteralExpression)this.myParam.replace((PsiElement)newLiteral);
        }
        return this.myParam;
    }

    @NotNull
    public String getValue() {
        String string = this.myStringValue == null ? "" : this.myStringValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/references/WebSocketPathParamReference", "getValue"));
        }
        return string;
    }

    @NotNull
    public Object[] getVariants() {
        String path;
        HashSet variants = new HashSet();
        WebSocketEndpoint endpoint = WebSocketPathParamReference.findEndpoint(this.myElement);
        if (endpoint != null && !StringUtil.isEmptyOrSpaces((String)(path = endpoint.getPath()))) {
            for (String name : new UriTemplateParser(path).getNames()) {
                variants.add(LookupElementBuilder.create((String)name).withIcon(PlatformIcons.VARIABLE_ICON));
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)variants);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/references/WebSocketPathParamReference", "getVariants"));
        }
        return objectArray;
    }
}

