/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.presentation.DiagramLineType;
import java.awt.Color;
import java.awt.Shape;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramRelationshipInfoAdapter
implements DiagramRelationshipInfo {
    private final String myName;
    private final DiagramLineType myLineType;
    private final String myLabel;
    private final int myWidth;
    private final String myFromLabel;
    private final String myToLabel;

    public DiagramRelationshipInfoAdapter(String name, DiagramLineType lineType, @Nullable String label, @Nullable String fromLabel, @Nullable String toLabel, int width) {
        this.myFromLabel = fromLabel;
        this.myToLabel = toLabel;
        this.myName = name == null ? "UNDEFINED" : name;
        this.myLineType = lineType == null ? DiagramLineType.SOLID : lineType;
        this.myLabel = label == null ? "" : label;
        this.myWidth = width;
    }

    public DiagramRelationshipInfoAdapter(String name, @Nullable DiagramLineType lineType, @Nullable String label) {
        this(name, lineType, label, null, null, 1);
    }

    public DiagramRelationshipInfoAdapter(String name, @Nullable DiagramLineType lineType, @Nullable String toLabel, @Nullable String fromLabel) {
        this(name, lineType, null, fromLabel, toLabel, 1);
    }

    public DiagramRelationshipInfoAdapter(String name, DiagramLineType lineType) {
        this(name, lineType, null);
    }

    public DiagramRelationshipInfoAdapter(String name) {
        this(name, null, null);
    }

    @Override
    public DiagramLineType getLineType() {
        return this.myLineType;
    }

    @Override
    public String getLabel() {
        return this.myLabel;
    }

    @Override
    public int getWidth() {
        return this.myWidth;
    }

    @Override
    public String getFromLabel() {
        return this.myToLabel;
    }

    @Override
    public String getToLabel() {
        return this.myFromLabel;
    }

    @Override
    public Color getLabelColor() {
        return null;
    }

    @Override
    public Color getFromLabelColor() {
        return null;
    }

    @Override
    public Color getToLabelColor() {
        return null;
    }

    @Override
    public abstract Shape getStartArrow();

    @Override
    public Shape getEndArrow() {
        return null;
    }

    public String toString() {
        return this.myName;
    }
}

