/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.Utils;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.NotNullFunction;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class DiagramIntentionAction
extends DiagramAction {
    private static final Logger LOG = Logger.getInstance(DiagramIntentionAction.class);
    private static final String NAME = "Show Intentions for Node";

    protected DiagramIntentionAction() {
        super(NAME, null, null);
    }

    @Override
    public void perform(AnActionEvent e) {
        final DiagramBuilder builder = DiagramIntentionAction.getBuilder(e);
        final DiagramNode node = DiagramIntentionAction.getSelectedNodes(e).get(0);
        ArrayList actions = new ArrayList();
        for (DiagramNodeIntentionAction action : builder.getProvider().getNodeIntentionActions()) {
            if (!action.isEnabled(e, builder)) continue;
            actions.add(action);
        }
        final JBList list = new JBList(actions);
        list.installCellRenderer((NotNullFunction)new NotNullFunction<Object, JComponent>(){

            @NotNull
            public JComponent fun(Object obj) {
                Presentation presentation = ((AnAction)obj).getTemplatePresentation();
                String actionText = presentation.getText();
                LOG.assertTrue(actionText != null, obj);
                String text = StringUtil.capitalize((String)StringUtil.wordsToBeginFromLowerCase((String)actionText));
                Icon icon = presentation.getIcon();
                JLabel label = new JLabel(text, icon == null ? AllIcons.Actions.IntentionBulb : icon, 2);
                label.setBorder(IdeBorderFactory.createEmptyBorder((int)4, (int)4, (int)4, (int)10));
                JLabel jLabel = label;
                if (jLabel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/actions/DiagramIntentionAction$1", "fun"));
                }
                return jLabel;
            }
        });
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setAutoselectOnMouseMove(true).setItemChoosenCallback(new Runnable(){

            @Override
            public void run() {
                Object value = list.getSelectedValue();
                if (value instanceof DiagramNodeIntentionAction) {
                    ((DiagramNodeIntentionAction)((Object)value)).perform(node, builder);
                }
            }
        }).createPopup();
        Utils.showPopupBeneathNode(popup, builder.getNode(node), builder.getView());
    }

    @Override
    public boolean isEnabled(AnActionEvent e, DiagramBuilder b) {
        for (DiagramNodeIntentionAction action : b.getProvider().getNodeIntentionActions()) {
            if (!action.isEnabled(e, b)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUndoable(AnActionEvent e) {
        return false;
    }

    @Override
    public String getActionName() {
        return NAME;
    }
}

