/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.actions.createnew;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.actions.createnew.AddNewElementAction;
import com.intellij.tapestry.intellij.actions.createnew.AddNewMixinDialog;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.tapestry.intellij.util.Validators;
import com.intellij.tapestry.intellij.view.nodes.MixinsNode;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class AddNewMixinAction
extends AddNewElementAction<MixinsNode> {
    public AddNewMixinAction() {
        super(MixinsNode.class);
    }

    @Override
    protected String getElementsRootPackage(@NotNull TapestryProject tapestryProject) {
        if (tapestryProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tapestryProject", "com/intellij/tapestry/intellij/actions/createnew/AddNewMixinAction", "getElementsRootPackage"));
        }
        return tapestryProject.getMixinsRootPackage();
    }

    public void actionPerformed(AnActionEvent event) {
        final Module module = AddNewMixinAction.getModule(event);
        if (module == null) {
            return;
        }
        String defaultMixinPath = this.getDefaultElementPath(event, module);
        if (defaultMixinPath == null) {
            return;
        }
        final AddNewMixinDialog addNewMixinDialog = new AddNewMixinDialog((Module)event.getDataContext().getData(DataKeys.MODULE.getName()), defaultMixinPath);
        final DialogBuilder builder = new DialogBuilder(module.getProject());
        builder.setCenterPanel((JComponent)addNewMixinDialog.getContentPane());
        builder.setTitle("New Tapestry Mixin");
        builder.setButtonsAlignment(0);
        builder.setPreferredFocusComponent(addNewMixinDialog.getNameComponent());
        builder.setOkOperation(new Runnable(){

            @Override
            public void run() {
                final String mixinName = addNewMixinDialog.getName();
                if (!Validators.isValidComponentName(mixinName)) {
                    Messages.showErrorDialog((String)"Invalid mixin name!", (String)CommonBundle.getErrorTitle());
                    return;
                }
                String classSourceDir = addNewMixinDialog.getClassSourceDirectory().getPath();
                TapestryModuleSupportLoader.getInstance(module).getState().setNewPagesClassesSourceDirectory(classSourceDir);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PsiDirectory classSourceDirectory = PsiManager.getInstance((Project)module.getProject()).findDirectory(addNewMixinDialog.getClassSourceDirectory());
                            TapestryUtils.createMixin(module, classSourceDirectory, mixinName, addNewMixinDialog.isReplaceExistingFiles());
                        }
                        catch (IllegalStateException ex) {
                            Messages.showWarningDialog((Project)module.getProject(), (String)ex.getMessage(), (String)"Error creating mixin");
                        }
                    }
                });
                builder.getWindow().dispose();
            }
        });
        builder.showModal(true);
    }
}

