/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.core.java;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.ClassUtil;
import com.intellij.tapestry.core.java.IJavaAnnotation;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.java.IJavaTypeCreator;
import com.intellij.tapestry.intellij.core.java.IntellijJavaAnnotation;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.core.java.IntellijJavaField;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.Map;

public class IntellijJavaTypeCreator
implements IJavaTypeCreator {
    private static final Logger _logger = Logger.getInstance((String)IntellijJavaTypeCreator.class.getName());
    private Module _module;

    public IntellijJavaTypeCreator(Module module) {
        this._module = module;
    }

    @Override
    public IJavaField createField(String name, IJavaClassType type, boolean isPrivate, boolean changeNameToReflectIdeSettings) {
        String fieldName = changeNameToReflectIdeSettings ? JavaCodeStyleManager.getInstance((Project)this._module.getProject()).propertyNameToVariableName(StringUtil.decapitalize((String)name), VariableKind.FIELD) : name;
        try {
            PsiField field = JavaPsiFacade.getInstance((Project)this._module.getProject()).getElementFactory().createField(fieldName, (PsiType)JavaPsiFacade.getInstance((Project)this._module.getProject()).getElementFactory().createType(((IntellijJavaClassType)type).getPsiClass()));
            field.getModifierList().setModifierProperty("private", isPrivate);
            return new IntellijJavaField(this._module, field);
        }
        catch (Throwable ex) {
            _logger.error(ex);
            return null;
        }
    }

    @Override
    public IJavaAnnotation createFieldAnnotation(IJavaField field, String fullyQualifiedName, Map<String, String> parameters) {
        StringBuffer annotationText = new StringBuffer();
        annotationText.append("@").append(fullyQualifiedName);
        if (parameters.size() > 0) {
            annotationText.append("(");
        }
        for (String parameterName : parameters.keySet()) {
            annotationText.append(parameterName).append("=").append(parameters.get(parameterName).startsWith("{") ? "" : "\"").append(parameters.get(parameterName)).append(parameters.get(parameterName).startsWith("{") ? "" : "\"").append(",");
        }
        if (parameters.size() > 0) {
            annotationText.deleteCharAt(annotationText.length() - 1);
            annotationText.append(")");
        }
        try {
            PsiAnnotation annotation = JavaPsiFacade.getInstance((Project)this._module.getProject()).getElementFactory().createAnnotationFromText(annotationText.toString(), (PsiElement)((IntellijJavaField)field).getPsiField());
            ((IntellijJavaField)field).getPsiField().getModifierList().addBefore((PsiElement)annotation, ((IntellijJavaField)field).getPsiField().getModifierList().getFirstChild());
            CodeStyleManager.getInstance((Project)this._module.getProject()).reformat((PsiElement)((IntellijJavaField)field).getPsiField());
            return new IntellijJavaAnnotation(annotation);
        }
        catch (IncorrectOperationException ex) {
            _logger.error((Throwable)ex);
            return null;
        }
    }

    @Override
    public boolean ensureClassImport(IJavaClassType baseClass, final IJavaClassType type) {
        if (!ImportUtils.nameCanBeImported((String)type.getFullyQualifiedName(), (PsiElement)((IntellijJavaClassType)baseClass).getPsiClass().getContainingFile())) {
            return false;
        }
        final PsiImportList importList = ((PsiJavaFile)((IntellijJavaClassType)baseClass).getPsiClass().getContainingFile()).getImportList();
        if (importList == null) {
            return false;
        }
        String packageName = ClassUtil.extractPackageName((String)type.getFullyQualifiedName());
        if (packageName.equals("java.lang")) {
            if (ImportUtils.hasOnDemandImportConflict((String)type.getFullyQualifiedName(), (PsiElement)((PsiJavaFile)((IntellijJavaClassType)baseClass).getPsiClass().getContainingFile()))) {
                IdeaUtils.runWriteCommand(null, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IntellijJavaTypeCreator.this.addImport(importList, ((IntellijJavaClassType)type).getPsiClass());
                        }
                        catch (IncorrectOperationException ex) {
                            _logger.error((Throwable)ex);
                        }
                    }
                });
                PsiDocumentManager.getInstance((Project)this._module.getProject()).doPostponedOperationsAndUnblockDocument(FileEditorManager.getInstance((Project)this._module.getProject()).getSelectedTextEditor().getDocument());
                return true;
            }
        } else {
            if (importList.findSingleClassImportStatement(type.getFullyQualifiedName()) == null) {
                IdeaUtils.runWriteCommand(null, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IntellijJavaTypeCreator.this.addImport(importList, ((IntellijJavaClassType)type).getPsiClass());
                        }
                        catch (IncorrectOperationException ex) {
                            _logger.error((Throwable)ex);
                        }
                    }
                });
                if (FileEditorManager.getInstance((Project)this._module.getProject()).getSelectedFiles().length > 0) {
                    PsiDocumentManager.getInstance((Project)this._module.getProject()).doPostponedOperationsAndUnblockDocument(FileEditorManager.getInstance((Project)this._module.getProject()).getSelectedTextEditor().getDocument());
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public void addImport(PsiImportList importList, PsiClass aClass) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)importList.getProject()).getElementFactory();
        PsiImportStatement importStatement = elementFactory.createImportStatement(aClass);
        importList.add((PsiElement)importStatement);
    }
}

