/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.codeInsight.hint.api.impls.XmlParameterInfoHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeImpl;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.xml.XmlElementDescriptor;
import org.jetbrains.annotations.NotNull;

public class JSAnnotationParameterInfoHandler
implements ParameterInfoHandler<JSAttribute, XmlElementDescriptor> {
    public boolean couldShowInLookup() {
        return true;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        if (!(item instanceof MutableLookupElement)) {
            return null;
        }
        Object o = item.getObject();
        if (o instanceof XmlElementDescriptor) {
            return new Object[]{o};
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public Object[] getParametersForDocumentation(XmlElementDescriptor p, ParameterInfoContext context) {
        return XmlParameterInfoHandler.getSortedDescriptors((XmlElementDescriptor)p);
    }

    public JSAttribute findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        XmlElementDescriptor elementDescriptor;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSAnnotationParameterInfoHandler", "findElementForParameterInfo"));
        }
        JSAttribute attribute = (JSAttribute)ParameterInfoUtils.findParentOfType((PsiFile)context.getFile(), (int)context.getOffset(), JSAttribute.class);
        if (attribute != null && (elementDescriptor = ((JSAttributeImpl)attribute).getBackedDescriptor()) != null) {
            context.setItemsToShow(new Object[]{elementDescriptor});
            return attribute;
        }
        return null;
    }

    public void showParameterInfo(@NotNull JSAttribute element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/JSAnnotationParameterInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSAnnotationParameterInfoHandler", "showParameterInfo"));
        }
        context.showHint((PsiElement)element, element.getTextOffset(), (ParameterInfoHandler)this);
    }

    public JSAttribute findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSAnnotationParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return (JSAttribute)ParameterInfoUtils.findParentOfType((PsiFile)context.getFile(), (int)context.getOffset(), JSAttribute.class);
    }

    public void updateParameterInfo(@NotNull JSAttribute parameterOwner, @NotNull UpdateParameterInfoContext context) {
        if (parameterOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterOwner", "com/intellij/javascript/JSAnnotationParameterInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSAnnotationParameterInfoHandler", "updateParameterInfo"));
        }
        if (context.getParameterOwner() != parameterOwner) {
            context.removeHint();
            return;
        }
        int currentParameterIndex = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)context.getOffset(), (IElementType)JSTokenTypes.COMMA);
        context.setCurrentParameter(currentParameterIndex);
    }

    @NotNull
    public String getParameterCloseChars() {
        if (",]{" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSAnnotationParameterInfoHandler", "getParameterCloseChars"));
        }
        return ",]{";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public void updateUI(XmlElementDescriptor p, final @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSAnnotationParameterInfoHandler", "updateUI"));
        }
        XmlParameterInfoHandler.updateElementDescriptor((XmlElementDescriptor)p, (ParameterInfoUIContext)context, (Function)new Function<String, Boolean>(){
            final JSAttribute attr;
            {
                this.attr = (JSAttribute)context.getParameterOwner();
            }

            public Boolean fun(String s) {
                return this.attr.getValueByName(s) != null;
            }
        });
    }
}

