/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.NodeJSRemoteSdkCredentials;
import com.intellij.javascript.nodejs.NodeLocalVersionsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeDetectionUtil {
    private static final Logger LOG = Logger.getInstance(NodeDetectionUtil.class);
    private static final String NODE_INTERPRETER_BASE_NAME = SystemInfo.isWindows ? "node.exe" : "node";
    private static final FileFilter NODE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path;
            if (SystemInfo.isWindows && (path = pathname.getAbsolutePath()).contains("Microsoft HPC Pack")) {
                return false;
            }
            return !SystemInfo.isUnix || !"/usr/sbin/node".equals(path = pathname.getAbsolutePath());
        }
    };

    private NodeDetectionUtil() {
    }

    @Nullable
    public static File findInterpreterInPath() {
        File interpreter = PathEnvironmentVariableUtil.findInPath((String)NODE_INTERPRETER_BASE_NAME, (FileFilter)NODE_FILTER);
        if (interpreter != null) {
            return interpreter;
        }
        NodeInterpreters interpreters = new NodeInterpreters();
        NodeDetectionUtil.addNodeInterpretersFromNvm(interpreters);
        NodeDetectionUtil.listNodeInterpretersFromHomeBrew(interpreters);
        if (interpreters.myInterpreters.size() == 1) {
            List<File> sortedInterpreters = interpreters.getSortedInterpreters();
            return (File)ContainerUtil.getFirstItem(sortedInterpreters);
        }
        return null;
    }

    @NotNull
    public static List<File> listAllPossibleNodeInterpreters() {
        List<File> list = NodeDetectionUtil.listAllPossibleNodeInterpreters(true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeDetectionUtil", "listAllPossibleNodeInterpreters"));
        }
        return list;
    }

    @NotNull
    public static List<String> listAllPossibleNodeInterpretersWithRemote() {
        List<String> strings = NodeDetectionUtil.listAllPossibleNodeInterpretersPaths();
        NodeJSRemoteInterpreterManager remote = NodeJSRemoteInterpreterManager.getInstance();
        if (remote != null) {
            strings.addAll(remote.getRemoteInterpreters());
        }
        List<String> list = strings;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeDetectionUtil", "listAllPossibleNodeInterpretersWithRemote"));
        }
        return list;
    }

    @NotNull
    public static List<String> listAllPossibleNodeInterpretersPaths() {
        List<File> files = NodeDetectionUtil.listAllPossibleNodeInterpreters(true);
        List<String> list = files.isEmpty() ? new ArrayList<String>() : ContainerUtil.map(files, (Function)new NotNullFunction<File, String>(){

            @NotNull
            public String fun(File dom) {
                String string = dom.getAbsolutePath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeDetectionUtil$2", "fun"));
                }
                return string;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeDetectionUtil", "listAllPossibleNodeInterpretersPaths"));
        }
        return list;
    }

    @NotNull
    public static List<File> listAllPossibleNodeInterpreters(boolean withPreviouslyUsedNodeInterpreters) {
        List fromPath = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)NODE_INTERPRETER_BASE_NAME, (FileFilter)NODE_FILTER);
        NodeInterpreters interpreters = new NodeInterpreters();
        for (File interpreterFile : fromPath) {
            interpreters.add(interpreterFile, null);
        }
        NodeDetectionUtil.addNodeInterpretersFromNvm(interpreters);
        NodeDetectionUtil.listNodeInterpretersFromHomeBrew(interpreters);
        NodeDetectionUtil.listNodeInterpretersFromNodist(interpreters);
        if (withPreviouslyUsedNodeInterpreters) {
            NodeDetectionUtil.addPreviouslyUsedNodeInterpreters(interpreters);
        }
        List<File> list = interpreters.getSortedInterpreters();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeDetectionUtil", "listAllPossibleNodeInterpreters"));
        }
        return list;
    }

    private static void addPreviouslyUsedNodeInterpreters(NodeInterpreters interpreters) {
        List<Pair<String, NodeLocalVersionsManager.VersionData>> versions = NodeLocalVersionsManager.getInstance().getVersions();
        for (Pair<String, NodeLocalVersionsManager.VersionData> version : versions) {
            interpreters.add(new File(FileUtil.toSystemDependentName((String)((String)version.getFirst()))), ((NodeLocalVersionsManager.VersionData)version.getSecond()).getVer());
        }
    }

    private static void listNodeInterpretersFromNodist(@NotNull NodeInterpreters interpreters) {
        File versionsDir;
        String nodistPrefix;
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/NodeDetectionUtil", "listNodeInterpretersFromNodist"));
        }
        if (SystemInfo.isWindows && !StringUtil.isEmpty((String)(nodistPrefix = EnvironmentUtil.getValue((String)"NODIST_PREFIX"))) && (versionsDir = new File(nodistPrefix, "v")).isAbsolute() && versionsDir.isDirectory()) {
            NodeDetectionUtil.addNodeInterpretersFromVersionDir(interpreters, versionsDir, false);
        }
    }

    private static void addNodeInterpretersFromNvm(@NotNull NodeInterpreters interpreters) {
        File nvmDir;
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/NodeDetectionUtil", "addNodeInterpretersFromNvm"));
        }
        String nvmDirPath = EnvironmentUtil.getValue((String)"NVM_DIR");
        if (StringUtil.isEmpty((String)nvmDirPath)) {
            if (SystemInfo.isUnix) {
                nvmDirPath = SystemProperties.getUserHome() + "/.nvm";
            } else {
                return;
            }
        }
        if (!(nvmDir = new File(nvmDirPath)).isAbsolute()) {
            return;
        }
        NodeDetectionUtil.addNodeInterpretersFromVersionDir(interpreters, nvmDir, true);
        File versionsDir = new File(nvmDir, "versions");
        if (versionsDir.isDirectory()) {
            NodeDetectionUtil.addNodeInterpretersFromVersionDir(interpreters, new File(versionsDir, "node"), true);
            NodeDetectionUtil.addNodeInterpretersFromVersionDir(interpreters, new File(versionsDir, "io.js"), true);
        }
    }

    private static void listNodeInterpretersFromHomeBrew(@NotNull NodeInterpreters interpreters) {
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/NodeDetectionUtil", "listNodeInterpretersFromHomeBrew"));
        }
        NodeDetectionUtil.addNodeInterpretersFromVersionDir(interpreters, new File("/usr/local/Cellar/node"), true);
    }

    private static void addNodeInterpretersFromVersionDir(@NotNull NodeInterpreters interpreters, @NotNull File parentDir, boolean insideBinDir) {
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/NodeDetectionUtil", "addNodeInterpretersFromVersionDir"));
        }
        if (parentDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDir", "com/intellij/javascript/nodejs/NodeDetectionUtil", "addNodeInterpretersFromVersionDir"));
        }
        if (!parentDir.isDirectory()) {
            return;
        }
        File[] dirs = parentDir.listFiles();
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            String relativePath;
            File interpreter;
            SemVer semVer = NodeDetectionUtil.parseSemVer(dir.getName());
            if (semVer == null || !(interpreter = new File(dir, relativePath = insideBinDir ? "bin" + File.separator + NODE_INTERPRETER_BASE_NAME : NODE_INTERPRETER_BASE_NAME)).isFile() || !interpreter.canExecute()) continue;
            interpreters.add(interpreter, semVer);
        }
    }

    @Nullable
    private static SemVer parseSemVer(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/nodejs/NodeDetectionUtil", "parseSemVer"));
        }
        name = StringUtil.trimStart((String)name, (String)"v");
        return SemVer.parseFromText((String)name);
    }

    @Nullable
    public static SemVer fetchInterpreterVersion(@NotNull String nodeInterpreterPath) {
        ProcessOutput output;
        if (nodeInterpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreterPath", "com/intellij/javascript/nodejs/NodeDetectionUtil", "fetchInterpreterVersion"));
        }
        if (NodeLocalVersionsManager.isRemote(nodeInterpreterPath)) {
            NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstanceOrPrompt("Getting node interpreter version");
            if (manager != null) {
                try {
                    RemoteSdkAdditionalData data = manager.getRemoteSdkAdditionalData(null, nodeInterpreterPath);
                    return manager.getNodeVersion(null, (NodeJSRemoteSdkCredentials)data.getRemoteSdkCredentials(false));
                }
                catch (RemoteSdkException e) {
                    LOG.warn((Throwable)e);
                }
                catch (InterruptedException e) {
                    LOG.warn((Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.warn((Throwable)e);
                }
            }
            return null;
        }
        if (nodeInterpreterPath.endsWith("/Contents/MacOS/Electron")) {
            return SemVer.parseFromText((String)"0.0.0");
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(nodeInterpreterPath);
        commandLine.addParameter("-v");
        try {
            output = NodeCommandLineUtil.execute(commandLine, 5000L, null);
        }
        catch (ExecutionException e) {
            LOG.warn("Cannot fetch node version, $ " + commandLine.getCommandLineString(), (Throwable)e);
            return null;
        }
        if (output.isTimeout()) {
            LOG.warn("Cannot fetch node version: timed out, $ " + commandLine.getCommandLineString());
            return null;
        }
        if (output.getExitCode() != 0) {
            LOG.warn("Cannot fetch node version: non-zero exit code " + output.getExitCode() + ", $ " + commandLine.getCommandLineString());
            return null;
        }
        List stdout = output.getStdoutLines(true);
        if (stdout.size() != 1) {
            LOG.warn("Cannot parse node version: single line was expected, actual line count: " + stdout.size() + ", stdout:" + stdout);
            return null;
        }
        return NodeDetectionUtil.parseSemVer((String)stdout.get(0));
    }

    private static class NodeInterpreter {
        private final File myInterpreter;
        private final SemVer mySemVer;

        public NodeInterpreter(@NotNull File interpreter, @Nullable SemVer semVer) {
            if (interpreter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/NodeDetectionUtil$NodeInterpreter", "<init>"));
            }
            this.myInterpreter = interpreter;
            this.mySemVer = semVer;
        }

        @NotNull
        public File getInterpreter() {
            File file = this.myInterpreter;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeDetectionUtil$NodeInterpreter", "getInterpreter"));
            }
            return file;
        }

        @Nullable
        public SemVer getSemVer() {
            return this.mySemVer;
        }

        public String toString() {
            return this.myInterpreter.getAbsolutePath() + (this.mySemVer != null ? ", " + this.mySemVer : "");
        }
    }

    private static class NodeInterpreters {
        private final List<NodeInterpreter> myInterpreters = ContainerUtil.newArrayList();

        private NodeInterpreters() {
        }

        public void add(@NotNull File interpreterFile, @Nullable SemVer semVer) {
            if (interpreterFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterFile", "com/intellij/javascript/nodejs/NodeDetectionUtil$NodeInterpreters", "add"));
            }
            if (semVer == null) {
                semVer = NodeLocalVersionsManager.getInstance().getVersion(interpreterFile);
            }
            this.myInterpreters.add(new NodeInterpreter(interpreterFile, semVer));
        }

        @NotNull
        public List<File> getSortedInterpreters() {
            Collections.sort(this.myInterpreters, new Comparator<NodeInterpreter>(){

                @Override
                public int compare(NodeInterpreter interpreter1, NodeInterpreter interpreter2) {
                    SemVer semVer1 = interpreter1.getSemVer();
                    SemVer semVer2 = interpreter2.getSemVer();
                    if (semVer1 != null && semVer2 != null) {
                        int res = semVer2.compareTo(semVer1);
                        if (res == 0) {
                            res = interpreter1.getInterpreter().getAbsolutePath().compareTo(interpreter2.getInterpreter().getAbsolutePath());
                        }
                        return res;
                    }
                    if (semVer1 == null && semVer2 == null) {
                        return interpreter1.getInterpreter().getAbsolutePath().compareTo(interpreter2.getInterpreter().getAbsolutePath());
                    }
                    return semVer1 == null ? -1 : 1;
                }
            });
            LinkedHashSet<File> result = new LinkedHashSet<File>(this.myInterpreters.size());
            for (NodeInterpreter interpreter : this.myInterpreters) {
                if (result.contains(interpreter.getInterpreter())) {
                    result.remove(interpreter.getInterpreter());
                }
                result.add(interpreter.getInterpreter());
            }
            ArrayList arrayList = ContainerUtil.newArrayList(result);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeDetectionUtil$NodeInterpreters", "getSortedInterpreters"));
            }
            return arrayList;
        }
    }
}

