/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModuleDirectorySearchProcessor {
    public static final NodeModuleDirectorySearchProcessor PROCESSOR = new NodeModuleDirectorySearchProcessor();

    public ResolvedModuleInfo doResolveModule(@Nullable VirtualFile moduleSourceRoot, @NotNull ModuleType type, @NotNull VirtualFile baseDir, @NotNull String requiredModuleName, boolean resolveDirectory, boolean respectPackageJson) {
        String childNamePrefix;
        VirtualFile parentDir;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor", "doResolveModule"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor", "doResolveModule"));
        }
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor", "doResolveModule"));
        }
        int lastSlashInd = (requiredModuleName = FileUtil.toSystemIndependentName((String)requiredModuleName)).lastIndexOf(47);
        if (lastSlashInd == -1) {
            parentDir = baseDir;
            childNamePrefix = requiredModuleName;
        } else {
            if (lastSlashInd == 0 || lastSlashInd == requiredModuleName.length() - 1) {
                return null;
            }
            parentDir = baseDir.findFileByRelativePath(requiredModuleName.substring(0, lastSlashInd));
            if (parentDir == null) {
                return null;
            }
            childNamePrefix = requiredModuleName.substring(lastSlashInd + 1);
        }
        boolean directory = false;
        VirtualFile fileOrDir = null;
        if (resolveDirectory && (fileOrDir = childNamePrefix.equals("..") ? parentDir.getParent() : (childNamePrefix.equals(".") ? parentDir : parentDir.findChild(childNamePrefix))) != null && fileOrDir.isValid()) {
            if (fileOrDir.isDirectory()) {
                directory = true;
            } else {
                if (moduleSourceRoot != null) {
                    return new ResolvedModuleInfo(moduleSourceRoot, fileOrDir, type);
                }
                return new ResolvedModuleInfo(fileOrDir, type);
            }
        }
        for (String ext : this.getExtensions()) {
            VirtualFile childFile = parentDir.findChild(childNamePrefix + ext);
            if (childFile == null || !NodeModuleSearchUtil.isFile(childFile)) continue;
            if (moduleSourceRoot != null) {
                return new ResolvedModuleInfo(moduleSourceRoot, childFile, type);
            }
            return new ResolvedModuleInfo(childFile, type);
        }
        if (directory && fileOrDir != null) {
            return this.loadDirectory(moduleSourceRoot, fileOrDir, type, respectPackageJson);
        }
        return null;
    }

    protected String[] getExtensions() {
        return NodeModuleSearchUtil.FILE_EXTENSIONS_IN_ORDER;
    }

    @Nullable
    private ResolvedModuleInfo loadDirectory(@Nullable VirtualFile moduleSourceRoot, @NotNull VirtualFile dir, @NotNull ModuleType type, boolean respectPackageJson) {
        String main;
        VirtualFile packageJson;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor", "loadDirectory"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor", "loadDirectory"));
        }
        String subPath = "index";
        boolean resolveDirectory = false;
        if (respectPackageJson && (packageJson = dir.findChild("package.json")) != null && (main = this.findPathInPackageJson(packageJson)) != null) {
            subPath = main;
            resolveDirectory = true;
        }
        if (moduleSourceRoot == null) {
            moduleSourceRoot = dir;
        }
        return this.doResolveModule(moduleSourceRoot, type, dir, subPath, resolveDirectory, false);
    }

    protected String findPathInPackageJson(VirtualFile json) {
        return NodeModuleSearchUtil.findMainKeyValueInPackageJson(json);
    }
}

