/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeSettings {
    private final String myInterpreterPath;
    private final AtomicReference<File> myGlobalNodeModulesDirRef;
    private final List<VirtualFile> myGlobalFolders;
    private volatile AtomicReference<String> myGuessedNpmExePathRef;

    public NodeSettings(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterPath", "com/intellij/javascript/nodejs/NodeSettings", "<init>"));
        }
        this.myGlobalNodeModulesDirRef = new AtomicReference();
        this.myInterpreterPath = interpreterPath;
        this.initGlobalNodeModulesDir();
        this.myGlobalFolders = NodeSettings.toVirtualFiles(this.getGlobalFolderPaths());
    }

    @NotNull
    private List<File> getGlobalFolderPaths() {
        File interpreterDir;
        File userHome;
        ArrayList<File> globalFolders = new ArrayList<File>(3);
        String userHomePath = SystemProperties.getUserHome();
        if (StringUtil.isNotEmpty((String)userHomePath) && (userHome = new File(userHomePath)).isAbsolute()) {
            globalFolders.add(new File(userHome, ".node_modules"));
            globalFolders.add(new File(userHome, ".node_libraries"));
        }
        if ((interpreterDir = this.getInterpreterDir()) != null) {
            globalFolders.add(new File(interpreterDir, "lib/node"));
        }
        ArrayList<File> arrayList = globalFolders;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeSettings", "getGlobalFolderPaths"));
        }
        return arrayList;
    }

    @NotNull
    public static List<VirtualFile> toVirtualFiles(@NotNull List<File> dirs) {
        if (dirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirs", "com/intellij/javascript/nodejs/NodeSettings", "toVirtualFiles"));
        }
        if (dirs.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeSettings", "toVirtualFiles"));
            }
            return list;
        }
        ArrayList vDirs = ContainerUtil.newArrayList();
        for (File dir : dirs) {
            VirtualFile vDir = VfsUtil.findFileByIoFile((File)dir, (boolean)false);
            if (vDir == null || !vDir.isValid() || !vDir.isDirectory()) continue;
            vDirs.add(vDir);
        }
        ArrayList arrayList = vDirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeSettings", "toVirtualFiles"));
        }
        return arrayList;
    }

    @Nullable
    private static String guessNpmExeFileByInterpreterPath(@NotNull String interpreterPath) {
        File npmFile;
        File parentDir;
        if (interpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterPath", "com/intellij/javascript/nodejs/NodeSettings", "guessNpmExeFileByInterpreterPath"));
        }
        String npmScriptName = SystemInfo.isWindows ? "npm.cmd" : "npm";
        File interpreterFile = new File(interpreterPath);
        if (interpreterFile.isFile() && (parentDir = interpreterFile.getParentFile()).isDirectory()) {
            File npmCliJsFile;
            File npmFile2 = new File(parentDir, npmScriptName);
            if (npmFile2.isFile() && npmFile2.canExecute()) {
                return npmFile2.getAbsolutePath();
            }
            String nodistNpmExePath = NodeSettings.guessNpmExeForNodist(interpreterPath, parentDir);
            if (nodistNpmExePath != null) {
                return nodistNpmExePath;
            }
            if (interpreterPath.contains("Cellar") && (npmCliJsFile = new File(parentDir, "libexec/npm/bin/npm-cli.js")).isFile() && npmCliJsFile.canExecute()) {
                return npmCliJsFile.getAbsolutePath();
            }
        }
        return (npmFile = PathEnvironmentVariableUtil.findInPath((String)npmScriptName, null)) != null ? npmFile.getAbsolutePath() : null;
    }

    @Nullable
    private static String guessNpmExeForNodist(@NotNull String interpreterPath, @NotNull File interpreterParentDir) {
        String nodistPrefix;
        if (interpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterPath", "com/intellij/javascript/nodejs/NodeSettings", "guessNpmExeForNodist"));
        }
        if (interpreterParentDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterParentDir", "com/intellij/javascript/nodejs/NodeSettings", "guessNpmExeForNodist"));
        }
        if (SystemInfo.isWindows && (nodistPrefix = EnvironmentUtil.getValue((String)"NODIST_PREFIX")) != null) {
            String independentNodistPrefix = FileUtil.toSystemIndependentName((String)nodistPrefix);
            independentNodistPrefix = StringUtil.trimEnd((String)independentNodistPrefix, (String)"/") + "/";
            if (FileUtil.toSystemIndependentName((String)interpreterPath).startsWith(independentNodistPrefix)) {
                File nodistNpmFile;
                File parentDir2;
                File parentDir1 = interpreterParentDir.getParentFile();
                File file = parentDir2 = parentDir1 != null ? parentDir1.getParentFile() : null;
                if (parentDir2 != null && (nodistNpmFile = new File(parentDir2, "bin\\npm.cmd")).isFile() && nodistNpmFile.canExecute()) {
                    return nodistNpmFile.getAbsolutePath();
                }
            }
        }
        return null;
    }

    @NotNull
    public String getInterpreterPath() {
        String string = this.myInterpreterPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeSettings", "getInterpreterPath"));
        }
        return string;
    }

    @Nullable
    public String getGuessedNpmExePath() {
        AtomicReference<String> guessedNpmExePathRef = this.myGuessedNpmExePathRef;
        if (guessedNpmExePathRef == null) {
            String guessedNpmExePath = NodeSettings.guessNpmExeFileByInterpreterPath(this.myInterpreterPath);
            this.myGuessedNpmExePathRef = guessedNpmExePathRef = new AtomicReference<String>(guessedNpmExePath);
        }
        return guessedNpmExePathRef.get();
    }

    @Nullable
    public VirtualFile getGlobalNodeModulesVirtualDir() {
        VirtualFile virtualDir;
        File dir = this.myGlobalNodeModulesDirRef.get();
        if (dir != null && dir.isDirectory() && (virtualDir = VfsUtil.findFileByIoFile((File)dir, (boolean)false)) != null && virtualDir.isValid()) {
            return virtualDir;
        }
        return null;
    }

    @NotNull
    public List<VirtualFile> getGlobalFolders() {
        List<VirtualFile> list = this.myGlobalFolders;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeSettings", "getGlobalFolders"));
        }
        return list;
    }

    @Nullable
    private File getInterpreterDir() {
        File interpreterFile = new File(this.myInterpreterPath);
        if (!interpreterFile.isFile() || !interpreterFile.canExecute()) {
            return null;
        }
        return interpreterFile.getParentFile();
    }

    public void initGlobalNodeModulesDir() {
        File guessedDir = this.guessGlobalModulesDirByInterpreterPath();
        this.myGlobalNodeModulesDirRef.set(guessedDir);
    }

    @Nullable
    private File guessGlobalModulesDirByInterpreterPath() {
        File libDir;
        File interpreterDir;
        File nodeModulesDir;
        String appDataDirPath;
        if (SystemInfo.isWindows && (appDataDirPath = EnvironmentUtil.getValue((String)"APPDATA")) != null) {
            File appDataDir = new File(appDataDirPath);
            if (appDataDirPath.trim().length() > 0 && appDataDir.isAbsolute() && appDataDir.isDirectory() && (nodeModulesDir = new File(appDataDir, "npm" + File.separatorChar + "node_modules")).isDirectory()) {
                return nodeModulesDir;
            }
        }
        if ((interpreterDir = this.getInterpreterDir()) == null) {
            return null;
        }
        if (SystemInfo.isWindows) {
            libDir = interpreterDir;
        } else {
            File root = interpreterDir.getParentFile();
            if (root == null) {
                return null;
            }
            libDir = new File(root, "lib");
        }
        nodeModulesDir = new File(libDir, "node_modules");
        return nodeModulesDir.isDirectory() ? nodeModulesDir : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeSettings settings = (NodeSettings)o;
        return this.myInterpreterPath.equals(settings.myInterpreterPath);
    }

    public int hashCode() {
        return this.myInterpreterPath.hashCode();
    }
}

