/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.filters.FileHyperlinkParsedData;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class NodeStackTraceFilter
implements Filter,
DumbAware {
    private static final Logger LOG = Logger.getInstance(NodeStackTraceFilter.class);
    private static final Pattern[] STACK_TRACE_PATTERNS = new Pattern[]{Pattern.compile("^(?:>>)?\\s*at\\s+(.+?):(\\d+)(:\\d+)?\\s*$"), Pattern.compile("^(?:>>)?\\s*at\\s+.*\\((.+?):(\\d+)(:\\d+)?\\)\\s*$")};
    private final Project myProject;
    private final NodeJsCoreLibraryManager myCoreLibraryManager;
    private final VirtualFile myBaseDir;

    public NodeStackTraceFilter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeStackTraceFilter", "<init>"));
        }
        this(project, null);
    }

    public NodeStackTraceFilter(@NotNull Project project, @Nullable File baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeStackTraceFilter", "<init>"));
        }
        this.myProject = project;
        this.myCoreLibraryManager = NodeJsCoreLibraryManager.getInstance(project);
        this.myBaseDir = NodeStackTraceFilter.findDir(baseDir == null ? null : baseDir.getAbsolutePath());
    }

    @Nullable
    private static VirtualFile findDir(@Nullable String baseDirPath) {
        if (StringUtil.isEmptyOrSpaces((String)baseDirPath)) {
            return null;
        }
        VirtualFile dir = LocalFileFinder.findFile((String)(baseDirPath = FileUtil.toSystemIndependentName((String)baseDirPath)));
        return dir != null && dir.isValid() && dir.isDirectory() ? dir : null;
    }

    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        FileHyperlinkParsedData data;
        try {
            data = NodeStackTraceFilter.parse(line);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to process '" + line + "'", (Throwable)e);
            return null;
        }
        if (data == null) {
            return null;
        }
        boolean libraryFile = false;
        String filePath = FileUtil.toSystemIndependentName((String)data.getFilePath());
        VirtualFile file = LocalFileFinder.findFile((String)filePath);
        if (file == null) {
            String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)data.getFilePath());
            file = this.myCoreLibraryManager.findCoreModuleFileByName(nameWithoutExtension);
            if (file != null) {
                libraryFile = true;
            } else if (this.myBaseDir != null) {
                file = this.myBaseDir.findFileByRelativePath(filePath);
            }
        }
        if (file == null) {
            return null;
        }
        if (!libraryFile) {
            libraryFile = JSLibraryUtil.isProbableLibraryFile(file);
        }
        int startOffset = entireLength - line.length();
        return new Filter.Result(startOffset + data.getHyperlinkStartOffset(), startOffset + data.getHyperlinkEndOffset(), (HyperlinkInfo)new OpenFileHyperlinkInfo(this.myProject, file, data.getDocumentLine(), data.getDocumentColumn()), libraryFile);
    }

    @Nullable
    private static Matcher findMatcher(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/nodejs/NodeStackTraceFilter", "findMatcher"));
        }
        for (Pattern pattern : STACK_TRACE_PATTERNS) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            return matcher;
        }
        return null;
    }

    @Nullable
    public static FileHyperlinkParsedData parse(@NotNull String line) {
        int documentLine;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/nodejs/NodeStackTraceFilter", "parse"));
        }
        Matcher matcher = NodeStackTraceFilter.findMatcher(line);
        if (matcher == null) {
            return null;
        }
        String filePath = matcher.group(1);
        try {
            documentLine = Integer.parseInt(matcher.group(2)) - 1;
        }
        catch (NumberFormatException e) {
            return null;
        }
        int documentColumn = NodeStackTraceFilter.getDocumentColumn(matcher);
        if (documentColumn < -1) {
            return null;
        }
        int hyperlinkEnd = matcher.end(matcher.groupCount());
        hyperlinkEnd = Math.max(hyperlinkEnd, matcher.end(matcher.groupCount() - 1));
        return new FileHyperlinkParsedData(filePath, documentLine, documentColumn, matcher.start(1), hyperlinkEnd);
    }

    private static int getDocumentColumn(@NotNull Matcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/javascript/nodejs/NodeStackTraceFilter", "getDocumentColumn"));
        }
        if (matcher.groupCount() < 3) {
            return -1;
        }
        String columnStr = matcher.group(3);
        if (columnStr == null) {
            return -1;
        }
        columnStr = StringUtil.trimStart((String)columnStr, (String)":");
        try {
            return Integer.parseInt(columnStr) - 1;
        }
        catch (NumberFormatException e) {
            return -2;
        }
    }
}

