/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.google.common.collect.ImmutableMap;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.PackageJsonField;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonData {
    private static final Logger LOG = Logger.getInstance(PackageJsonData.class);
    private final Map<String, PackageJsonField> myTypeByDependencyNameMap;

    public PackageJsonData(@NotNull Map<PackageJsonField, List<String>> dependencyByTypeMap) {
        if (dependencyByTypeMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyByTypeMap", "com/intellij/javascript/nodejs/PackageJsonData", "<init>"));
        }
        HashMap typeByDependencyNameMap = ContainerUtil.newHashMap();
        for (Map.Entry<PackageJsonField, List<String>> entry : dependencyByTypeMap.entrySet()) {
            for (String dependencyName : entry.getValue()) {
                typeByDependencyNameMap.put(dependencyName, entry.getKey());
            }
        }
        this.myTypeByDependencyNameMap = ImmutableMap.copyOf((Map)typeByDependencyNameMap);
    }

    public boolean isDependencyOfAnyType(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/nodejs/PackageJsonData", "isDependencyOfAnyType"));
        }
        return this.myTypeByDependencyNameMap.containsKey(name);
    }

    @NotNull
    public static PackageJsonData parse(@NotNull VirtualFile packageJsonFile, @Nullable Document packageJsonDocument) {
        if (packageJsonFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonFile", "com/intellij/javascript/nodejs/PackageJsonData", "parse"));
        }
        CharSequence text = PackageJsonData.loadText(packageJsonFile, packageJsonDocument);
        if (text != null) {
            PackageJsonData packageJsonData;
            block5: {
                try {
                    Map<PackageJsonField, List<String>> data = PackageJsonData.doParse(packageJsonFile, text);
                    packageJsonData = new PackageJsonData(data);
                    if (packageJsonData != null) break block5;
                }
                catch (Exception e) {
                    LOG.warn("Failed to parse " + packageJsonFile.getPath() + ": " + e.getMessage());
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/PackageJsonData", "parse"));
            }
            return packageJsonData;
        }
        PackageJsonData packageJsonData = new PackageJsonData(Collections.emptyMap());
        if (packageJsonData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/PackageJsonData", "parse"));
        }
        return packageJsonData;
    }

    @Nullable
    private static CharSequence loadText(@NotNull VirtualFile packageJsonFile, @Nullable Document packageJsonDocument) {
        if (packageJsonFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonFile", "com/intellij/javascript/nodejs/PackageJsonData", "loadText"));
        }
        if (packageJsonDocument != null) {
            return packageJsonDocument.getCharsSequence();
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)packageJsonFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    private static Map<PackageJsonField, List<String>> doParse(@NotNull VirtualFile packageJson, @NotNull CharSequence text) throws IOException {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/PackageJsonData", "doParse"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/nodejs/PackageJsonData", "doParse"));
        }
        JsonReader reader = new JsonReader((Reader)new CharSequenceReader(text));
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            throw new IOException("Top level element should be object");
        }
        reader.beginObject();
        EnumMap dependenciesByType = ContainerUtil.newEnumMap(PackageJsonField.class);
        while (reader.hasNext()) {
            String key = reader.nextName();
            PackageJsonField dependencyType = PackageJsonField.findDependencyByName(key);
            if (dependencyType != null) {
                List<String> dependencies = PackageJsonData.readPackages(reader, packageJson, dependencyType);
                dependenciesByType.put(dependencyType, dependencies);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        EnumMap enumMap = dependenciesByType;
        if (enumMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/PackageJsonData", "doParse"));
        }
        return enumMap;
    }

    @NotNull
    private static List<String> readPackages(@NotNull JsonReader reader, @NotNull VirtualFile packageJson, @NotNull PackageJsonField dependencyType) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/javascript/nodejs/PackageJsonData", "readPackages"));
        }
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/PackageJsonData", "readPackages"));
        }
        if (dependencyType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyType", "com/intellij/javascript/nodejs/PackageJsonData", "readPackages"));
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            LOG.warn("Failed to parse '" + (Object)((Object)dependencyType) + "' of " + packageJson.getPath() + ": expected " + JsonToken.BEGIN_OBJECT + ", actual " + reader.peek());
            reader.skipValue();
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/PackageJsonData", "readPackages"));
            }
            return list;
        }
        reader.beginObject();
        ArrayList packages = ContainerUtil.newArrayList();
        while (reader.hasNext()) {
            String key = reader.nextName();
            packages.add(key);
            reader.skipValue();
        }
        reader.endObject();
        ArrayList arrayList = packages;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/PackageJsonData", "readPackages"));
        }
        return arrayList;
    }
}

