/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.util.Ref;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeJsInterpreter {
    @NotNull
    public abstract NodeJsInterpreterType<? extends NodeJsInterpreter> getType();

    @NotNull
    public abstract String getReferenceName();

    @NotNull
    public abstract String getPresentableName();

    @Nullable
    public abstract Ref<SemVer> getCachedVersion();

    public abstract void fetchVersion(@NotNull NullableConsumer<SemVer> var1);

    @Nullable
    public static NodeJsInterpreter tryCast(@Nullable Object obj) {
        return (NodeJsInterpreter)ObjectUtils.tryCast((Object)obj, NodeJsInterpreter.class);
    }

    public String getOldPath() {
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(this);
        if (localInterpreter != null) {
            return localInterpreter.getInterpreterSystemDependentPath();
        }
        NodeJsRemoteInterpreter remoteInterpreter = NodeJsRemoteInterpreter.tryCast(this);
        if (remoteInterpreter != null) {
            return remoteInterpreter.getRemoteUrl();
        }
        return this.getReferenceName();
    }
}

