/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRenderer;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpretersDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpreterField
extends ComponentWithBrowseButton<ComboBox> {
    private static final Object ADD_ANOTHER_INTERPRETER = new Object();
    private final Project myProject;
    private final ComboBox myComboBox;
    private final DefaultComboBoxModel<Object> myModel;
    private final boolean myEnableRemote;
    private final List<NodeJsInterpreterChangeListener> myChangeListeners;

    public NodeJsInterpreterField(@NotNull Project project, boolean enableRemote) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField", "<init>"));
        }
        super((JComponent)new ComboBox(), null);
        this.myChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeJsInterpreterField.this.showInterpretersDialog();
            }
        });
        this.myProject = project;
        this.myComboBox = (ComboBox)this.getChildComponent();
        this.myComboBox.setRenderer((ListCellRenderer)new DelegatingListCellRenderer());
        this.myModel = new DefaultComboBoxModel();
        this.myComboBox.setModel(this.myModel);
        this.myEnableRemote = enableRemote;
        this.myComboBox.setMinimumAndPreferredWidth(0);
        this.myComboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                NodeJsInterpreterField.this.myComboBox.removePopupMenuListener((PopupMenuListener)((Object)this));
                NodeJsInterpreterField.this.setState(false, null);
            }
        });
        this.myComboBox.addItemListener(new ItemListener(){
            private Object myLastSelectedItem;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                Object selectedItem = NodeJsInterpreterField.this.myComboBox.getSelectedItem();
                if (selectedItem == ADD_ANOTHER_INTERPRETER) {
                    NodeJsInterpreterField.this.myComboBox.setSelectedItem(this.myLastSelectedItem);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NodeJsInterpreterField.this.showInterpretersDialog();
                        }
                    }, ModalityState.current());
                } else if (this.myLastSelectedItem != selectedItem) {
                    this.myLastSelectedItem = selectedItem;
                    for (NodeJsInterpreterChangeListener listener : NodeJsInterpreterField.this.myChangeListeners) {
                        listener.interpreterChanged(NodeJsInterpreter.tryCast(selectedItem));
                    }
                }
            }
        });
    }

    public boolean isDefaultProjectInterpreterField() {
        return false;
    }

    public void addChangeListener(@NotNull NodeJsInterpreterChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField", "addChangeListener"));
        }
        this.myChangeListeners.add(listener);
    }

    private void showInterpretersDialog() {
        NodeJsInterpretersDialog dialog = new NodeJsInterpretersDialog(this.myProject, this.isDefaultProjectInterpreterField(), this.myEnableRemote);
        Pair<Boolean, NodeJsInterpreter> pair = dialog.showAndGetSelected(NodeJsInterpreter.tryCast(this.myModel.getSelectedItem()));
        if (((Boolean)pair.getFirst()).booleanValue()) {
            this.setState(true, (NodeJsInterpreter)pair.getSecond());
        }
    }

    private void setState(boolean setSelectedItem, @Nullable NodeJsInterpreter selectedInterpreter) {
        List<NodeJsInterpreterType> types = NodeJsInterpretersDialog.enabledTypes(this.myEnableRemote);
        List<NodeJsInterpreter> interpreters = NodeJsInterpreterType.getInterpretersFor(types);
        NodeJsInterpreter previouslySelected = (NodeJsInterpreter)this.myComboBox.getSelectedItem();
        SwingHelper.updateItems((JComboBox)this.myComboBox, interpreters, null);
        this.myComboBox.addItem(ADD_ANOTHER_INTERPRETER);
        if (setSelectedItem) {
            this.myComboBox.setSelectedItem((Object)selectedInterpreter);
        } else if (previouslySelected == null) {
            this.myComboBox.setSelectedItem(null);
        }
    }

    public void setInterpreter(@Nullable NodeJsInterpreter interpreter) {
        this.myModel.setSelectedItem(interpreter);
    }

    public void setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
        if (interpreterRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterRef", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField", "setInterpreterRef"));
        }
        NodeJsInterpreter interpreter = interpreterRef.resolve(this.myProject);
        this.setInterpreter(interpreter);
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreter projectInterpreter;
        NodeJsInterpreter selectedInterpreter = this.getInterpreter();
        if (ComparatorUtil.equalsNullable((Object)selectedInterpreter, (Object)(projectInterpreter = NodeJsInterpreterManager.getInstance(this.myProject).getDefault()))) {
            NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            if (nodeJsInterpreterRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField", "getInterpreterRef"));
            }
            return nodeJsInterpreterRef;
        }
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create(selectedInterpreter);
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField", "getInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return NodeJsInterpreter.tryCast(this.myComboBox.getSelectedItem());
    }

    public void setPreferredWidthToFitText() {
        Dimension d = this.myComboBox.getPreferredSize();
        SwingHelper.setPreferredWidth((Component)this.myComboBox, (int)d.width);
    }

    private class DelegatingListCellRenderer
    implements ListCellRenderer<Object> {
        private final SpecialValueRenderer mySpecialValueRenderer = new SpecialValueRenderer();
        private final NodeJsInterpreterRenderer myInterpreterRenderer = new NodeJsInterpreterRenderer(true, new Predicate<NodeJsInterpreter>(){

            public boolean apply(@Nullable NodeJsInterpreter input) {
                if (input == null || NodeJsInterpreterField.this.isDefaultProjectInterpreterField()) {
                    return false;
                }
                NodeJsInterpreter projectInterpreter = NodeJsInterpreterManager.getInstance(NodeJsInterpreterField.this.myProject).getDefault();
                return input.equals(projectInterpreter);
            }
        });

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object renderer = value instanceof NodeJsInterpreter ? this.myInterpreterRenderer : this.mySpecialValueRenderer;
            return renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private static class SpecialValueRenderer
    extends ColoredListCellRendererWrapper<Object> {
        public SpecialValueRenderer() {
            this.setIpad((Insets)JBUI.insets((int)0, (int)2, (int)0, (int)0));
        }

        protected void doCustomize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value == null) {
                this.append("<No interpreter>", new SimpleTextAttributes(0, (Color)JBColor.RED));
            } else if (value == ADD_ANOTHER_INTERPRETER) {
                this.append(" Add...", new SimpleTextAttributes(0, (Color)JBColor.darkGray));
            } else {
                this.append("Unexpected value", new SimpleTextAttributes(0, (Color)JBColor.RED));
            }
        }
    }
}

