/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.NodeLocalVersionsManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreterType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpreterRef {
    public static final String PROJECT_LEVEL = "project";
    private final String myReferenceName;

    private NodeJsInterpreterRef(@NotNull String referenceName) {
        if (referenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef", "<init>"));
        }
        this.myReferenceName = FileUtil.toSystemIndependentName((String)referenceName);
    }

    private NodeJsInterpreterRef(@Nullable NodeJsInterpreter interpreter) {
        this.myReferenceName = interpreter == null ? "" : interpreter.getReferenceName();
    }

    @NotNull
    public String getReferenceName() {
        String string = this.myReferenceName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef", "getReferenceName"));
        }
        return string;
    }

    @Nullable
    public NodeJsInterpreter resolve(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PROJECT_LEVEL, "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef", "resolve"));
        }
        if (PROJECT_LEVEL.equals(this.myReferenceName)) {
            return NodeJsInterpreterManager.getInstance(project).getDefault();
        }
        return this.resolveWithoutAliases();
    }

    @Nullable
    public NodeJsInterpreter resolveWithoutAliases() {
        if (this.myReferenceName.isEmpty()) {
            return null;
        }
        NodeJsInterpreterType type = this.isRemote() ? NodeJsRemoteInterpreterType.getInstance() : NodeJsLocalInterpreterType.getInstance();
        return type.findByReferenceName(this.myReferenceName);
    }

    private boolean isRemote() {
        return NodeLocalVersionsManager.isRemote(this.myReferenceName);
    }

    @Nullable
    public static NodeJsInterpreterRef createProjectRef() {
        return new NodeJsInterpreterRef(PROJECT_LEVEL);
    }

    @Nullable
    public static NodeJsInterpreterRef create(@NotNull String referenceName) {
        if (referenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef", "create"));
        }
        return new NodeJsInterpreterRef(referenceName);
    }

    @Nullable
    public static NodeJsInterpreterRef create(@Nullable NodeJsInterpreter interpreter) {
        return new NodeJsInterpreterRef(interpreter);
    }
}

