/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeJsInterpreterType<T extends NodeJsInterpreter> {
    @NotNull
    public abstract String getName();

    public boolean isAvailable() {
        return true;
    }

    @Nullable
    public abstract T findByReferenceName(@NotNull String var1);

    @NotNull
    public List<T> suggestToAddInterpreters() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterType", "suggestToAddInterpreters"));
        }
        return list;
    }

    @NotNull
    public abstract List<T> getInterpreters();

    public abstract void setInterpreters(@NotNull List<T> var1);

    @Nullable
    public abstract T showAddDialog(@NotNull Project var1);

    public boolean isInplaceEditorAvailable() {
        return true;
    }

    @Nullable
    public T edit(@NotNull Project project, @NotNull T interpreter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterType", "edit"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterType", "edit"));
        }
        throw new IllegalStateException("Please implement 'edit' method, since " + this.getClass().getName() + " does not support inline editor");
    }

    @NotNull
    public abstract NodeJsInterpreterEditor<T> getEditor(@NotNull Project var1);

    @NotNull
    public static List<NodeJsInterpreter> getInterpretersFor(@NotNull List<NodeJsInterpreterType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterType", "getInterpretersFor"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (NodeJsInterpreterType type : types) {
            result.addAll(type.getInterpreters());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterType", "getInterpretersFor"));
        }
        return arrayList;
    }

    public String toString() {
        return this.getName();
    }
}

