/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.text.SemVer;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsLocalInterpreter
extends NodeJsInterpreter {
    private static final String NPM_EXECUTABLE_NAME = SystemInfo.isWindows ? "npm.cmd" : "npm";
    static final String WIN_EXE_EXT = ".exe";
    private final String myInterpreterSystemIndependentPath;
    private final String myInterpreterSystemDependentPath;
    private final File myInterpreter;
    private volatile Ref<String> myNpmPackageDirRef;

    public NodeJsLocalInterpreter(@NotNull String interpreterPath, @Nullable String npmPackageDir) {
        if (interpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterPath", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "<init>"));
        }
        this.myInterpreterSystemIndependentPath = FileUtil.toSystemIndependentName((String)interpreterPath);
        this.myInterpreterSystemDependentPath = FileUtil.toSystemDependentName((String)interpreterPath);
        this.myInterpreter = new File(interpreterPath);
        if (!StringUtil.isEmptyOrSpaces((String)npmPackageDir)) {
            this.myNpmPackageDirRef = Ref.create((Object)npmPackageDir);
        }
    }

    @Override
    @NotNull
    public String getReferenceName() {
        String path = this.myInterpreterSystemDependentPath;
        if (SystemInfo.isWindows && path.endsWith(WIN_EXE_EXT)) {
            path = path.substring(0, path.length() - WIN_EXE_EXT.length());
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getReferenceName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String userHome = SystemProperties.getUserHome();
        if (StringUtil.isEmptyOrSpaces((String)userHome)) {
            String string = this.myInterpreterSystemDependentPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getPresentableName"));
            }
            return string;
        }
        String userHomeWithSeparator = (userHome = StringUtil.trimEnd((String)userHome, (char)File.separatorChar)) + File.separatorChar;
        if (this.myInterpreterSystemDependentPath.startsWith(userHomeWithSeparator)) {
            String string = "~" + this.myInterpreterSystemDependentPath.substring(userHome.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getPresentableName"));
            }
            return string;
        }
        String string = this.myInterpreterSystemDependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getPresentableName"));
        }
        return string;
    }

    @Override
    @Nullable
    public Ref<SemVer> getCachedVersion() {
        return NodeJsLocalInterpreterManager.getInstance().getCachedVersion(this);
    }

    @Override
    public void fetchVersion(@NotNull NullableConsumer<SemVer> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "fetchVersion"));
        }
        NodeJsLocalInterpreterManager.getInstance().fetchVersion(this, consumer);
    }

    @NotNull
    public String getInterpreterSystemDependentPath() {
        String string = this.myInterpreterSystemDependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getInterpreterSystemDependentPath"));
        }
        return string;
    }

    @NotNull
    public String getInterpreterSystemIndependentPath() {
        String string = this.myInterpreterSystemIndependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getInterpreterSystemIndependentPath"));
        }
        return string;
    }

    public boolean isValid() {
        return this.myInterpreter.isFile() && this.myInterpreter.canExecute();
    }

    @NotNull
    public NodeJsLocalInterpreterType getType() {
        NodeJsLocalInterpreterType nodeJsLocalInterpreterType = NodeJsLocalInterpreterType.getInstance();
        if (nodeJsLocalInterpreterType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getType"));
        }
        return nodeJsLocalInterpreterType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeJsLocalInterpreter that = (NodeJsLocalInterpreter)o;
        return this.myInterpreterSystemIndependentPath.equals(that.myInterpreterSystemIndependentPath);
    }

    public int hashCode() {
        return this.myInterpreterSystemIndependentPath.hashCode();
    }

    public String toString() {
        return this.myInterpreterSystemIndependentPath;
    }

    @NotNull
    public String getNpmPackageDir() {
        Ref<String> npmPackageDirRef = this.myNpmPackageDirRef;
        if (npmPackageDirRef != null) {
            String string = StringUtil.notNullize((String)((String)npmPackageDirRef.get()));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getNpmPackageDir"));
            }
            return string;
        }
        String npmPackageDir = this.detectNpmPackageDir();
        this.myNpmPackageDirRef = Ref.create((Object)npmPackageDir);
        String string = StringUtil.notNullize((String)npmPackageDir);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getNpmPackageDir"));
        }
        return string;
    }

    @NotNull
    public String getNpmPackageDirNoDetection() {
        String string = StringUtil.notNullize((String)((String)Ref.deref(this.myNpmPackageDirRef)));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getNpmPackageDirNoDetection"));
        }
        return string;
    }

    @Nullable
    private String detectNpmPackageDir() {
        File npmExecutable;
        if (this.myInterpreter.isFile()) {
            File rootDir;
            File binDir = this.myInterpreter.getParentFile();
            File file = rootDir = binDir != null ? binDir.getParentFile() : null;
            if (rootDir != null) {
                File npmPackageDir = new File(rootDir, "lib/node_modules/npm");
                if (npmPackageDir.isDirectory()) {
                    return npmPackageDir.getAbsolutePath();
                }
                if (SystemInfo.isWindows && (npmPackageDir = new File(binDir, "node_modules/npm")).isDirectory()) {
                    return npmPackageDir.getAbsolutePath();
                }
                String nodistNpmExePath = this.guessNpmPackageDirForNodist(binDir);
                if (nodistNpmExePath != null) {
                    return nodistNpmExePath;
                }
                if (this.myInterpreterSystemIndependentPath.contains("/Cellar/") && (npmPackageDir = new File(binDir, "libexec/npm")).isDirectory()) {
                    return npmPackageDir.getAbsolutePath();
                }
            }
        }
        if ((npmExecutable = PathEnvironmentVariableUtil.findInPath((String)NPM_EXECUTABLE_NAME, null)) != null) {
            return NodeJsLocalInterpreter.guessNpmPackageDirByNpmExecutable(npmExecutable);
        }
        return null;
    }

    @Nullable
    private String guessNpmPackageDirForNodist(@NotNull File binDir) {
        String nodistPrefix;
        if (binDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binDir", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "guessNpmPackageDirForNodist"));
        }
        if (SystemInfo.isWindows && (nodistPrefix = EnvironmentUtil.getValue((String)"NODIST_PREFIX")) != null) {
            nodistPrefix = FileUtil.toSystemIndependentName((String)nodistPrefix);
            if (this.myInterpreterSystemIndependentPath.startsWith(nodistPrefix = StringUtil.trimEnd((String)nodistPrefix, (String)"/") + "/")) {
                File nodistNpmFile;
                File parentDir2;
                File parentDir1 = binDir.getParentFile();
                File file = parentDir2 = parentDir1 != null ? parentDir1.getParentFile() : null;
                if (parentDir2 != null && (nodistNpmFile = new File(parentDir2, "bin\\npm.cmd")).isFile() && nodistNpmFile.canExecute()) {
                    return NodeJsLocalInterpreter.guessNpmPackageDirByNpmExecutable(nodistNpmFile);
                }
            }
        }
        return null;
    }

    @Nullable
    private static String guessNpmPackageDirByNpmExecutable(@NotNull File npmExecutable) {
        File npmPackageDir;
        File root;
        if (npmExecutable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "npmExecutable", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "guessNpmPackageDirByNpmExecutable"));
        }
        File binDir = npmExecutable.getParentFile();
        File file = root = binDir != null ? binDir.getParentFile() : null;
        if (root != null && (npmPackageDir = new File(root, "lib/node_modules/npm")).isDirectory()) {
            return npmPackageDir.getAbsolutePath();
        }
        return null;
    }

    @Nullable
    public static NodeJsLocalInterpreter tryCast(@Nullable NodeJsInterpreter interpreter) {
        return (NodeJsLocalInterpreter)ObjectUtils.tryCast((Object)interpreter, NodeJsLocalInterpreter.class);
    }
}

