/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@State(name="NodeJsLocalInterpreterManager", storages={@Storage(file="$APP_CONFIG$/node-js-local-interpreters.xml", roamingType=RoamingType.DISABLED)})
public class NodeJsLocalInterpreterManager
implements PersistentStateComponent<Element> {
    private static final String LOCAL_INTERPRETERS_TAG_NAME = "local-interpreters";
    private static final String LOCAL_INTERPRETER_TAG_NAME = "local-interpreter";
    private static final String PATH_ATTR_NAME = "path";
    public static final String VERSION_CACHE_TAG_NAME = "version-cache";
    private static final String VERSION_ATTR_NAME = "version";
    private static final String VERSION_LAST_MODIFIED_ATTR_NAME = "last-modified";
    private static final String NPM_TAG_NAME = "npm-package";
    private static final String EXCLUDED_ATTR_NAME = "excluded";
    private final BoundedTaskExecutor myExecutorService = new BoundedTaskExecutor((Executor)PooledThreadExecutor.INSTANCE, 1);
    private final ConcurrentMap<String, TimestampedSemVer> myVersionCache = ContainerUtil.newConcurrentMap();
    private Set<String> myDetectedInterpreterPaths;
    private List<NodeJsLocalInterpreter> myInterpreters;
    private Set<String> myExcludedInterpreterPaths = Collections.emptySet();

    @NotNull
    public static NodeJsLocalInterpreterManager getInstance() {
        NodeJsLocalInterpreterManager nodeJsLocalInterpreterManager = (NodeJsLocalInterpreterManager)ServiceManager.getService(NodeJsLocalInterpreterManager.class);
        if (nodeJsLocalInterpreterManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "getInstance"));
        }
        return nodeJsLocalInterpreterManager;
    }

    @Nullable
    public Ref<SemVer> getCachedVersion(@NotNull NodeJsLocalInterpreter interpreter) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "getCachedVersion"));
        }
        String interpreterPath = interpreter.getInterpreterSystemDependentPath();
        TimestampedSemVer tsv = (TimestampedSemVer)this.myVersionCache.get(interpreterPath);
        if (tsv != null) {
            File file = new File(interpreterPath);
            if (file.lastModified() == tsv.myLastModified) {
                if (tsv.myVersion == null && tsv.myLoadedFromXml) {
                    this.fetchVersion(interpreter, null);
                }
                return Ref.create((Object)tsv.myVersion);
            }
            this.myVersionCache.remove(interpreterPath);
        }
        return null;
    }

    public void fetchVersion(@NotNull NodeJsLocalInterpreter interpreter, final @Nullable NullableConsumer<SemVer> consumer) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "fetchVersion"));
        }
        final String interpreterPath = interpreter.getInterpreterSystemDependentPath();
        this.myExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                SemVer version = NodeDetectionUtil.fetchInterpreterVersion(interpreterPath);
                File interpreter = new File(interpreterPath);
                NodeJsLocalInterpreterManager.this.myVersionCache.put(interpreterPath, new TimestampedSemVer(version, interpreter.lastModified(), false));
                if (consumer != null) {
                    consumer.consume((Object)version);
                }
            }
        });
    }

    @Nullable
    public Element getState() {
        List<NodeJsLocalInterpreter> interpreters = this.myInterpreters;
        if (interpreters == null) {
            return null;
        }
        Element parent = new Element(LOCAL_INTERPRETERS_TAG_NAME);
        for (NodeJsLocalInterpreter interpreter : interpreters) {
            Element interpreterElement = new Element(LOCAL_INTERPRETER_TAG_NAME);
            interpreterElement.setAttribute(PATH_ATTR_NAME, interpreter.getInterpreterSystemIndependentPath());
            this.addVersionCacheElementIfNeeded(interpreterElement, interpreter.getInterpreterSystemIndependentPath());
            String npmPackage = interpreter.getNpmPackageDirNoDetection();
            if (StringUtil.isNotEmpty((String)npmPackage)) {
                JDOMExternalizerUtil.addElementWithValueAttribute((Element)interpreterElement, (String)NPM_TAG_NAME, (String)npmPackage);
            }
            parent.addContent(interpreterElement);
        }
        Set<String> excludedInterpreterPaths = this.updateExcludedInterpreterPaths(this.myInterpreters);
        for (String excludedInterpreterPath : excludedInterpreterPaths) {
            Element interpreterElement = new Element(LOCAL_INTERPRETER_TAG_NAME);
            interpreterElement.setAttribute(PATH_ATTR_NAME, excludedInterpreterPath);
            interpreterElement.setAttribute(EXCLUDED_ATTR_NAME, Boolean.toString(true));
            parent.addContent(interpreterElement);
        }
        return parent;
    }

    private void addVersionCacheElementIfNeeded(@NotNull Element parent, @NotNull String interpreterPath) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "addVersionCacheElementIfNeeded"));
        }
        if (interpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterPath", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "addVersionCacheElementIfNeeded"));
        }
        TimestampedSemVer tsv = (TimestampedSemVer)this.myVersionCache.get(interpreterPath);
        if (tsv != null) {
            SemVer version = tsv.myVersion;
            Element versionElement = new Element(VERSION_CACHE_TAG_NAME);
            if (version != null) {
                versionElement.setAttribute(VERSION_ATTR_NAME, version.getRawVersion());
            }
            versionElement.setAttribute(VERSION_LAST_MODIFIED_ATTR_NAME, String.valueOf(tsv.myLastModified));
            parent.addContent(versionElement);
        }
    }

    @NotNull
    private Set<String> getDetectedInterpreterPaths() {
        List<File> interpreters = NodeDetectionUtil.listAllPossibleNodeInterpreters();
        HashSet interpreterPaths = ContainerUtil.newHashSet((int)interpreters.size());
        for (File interpreter : interpreters) {
            interpreterPaths.add(FileUtil.toSystemIndependentName((String)interpreter.getAbsolutePath()));
        }
        this.myDetectedInterpreterPaths = interpreterPaths;
        HashSet hashSet = interpreterPaths;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "getDetectedInterpreterPaths"));
        }
        return hashSet;
    }

    public void loadState(Element state) {
        List children = state.getChildren(LOCAL_INTERPRETER_TAG_NAME);
        HashSet excludedInterpreterPaths = ContainerUtil.newHashSet();
        ArrayList interpreters = ContainerUtil.newArrayList();
        for (Element interpreterElement : children) {
            String interpreterPath = interpreterElement.getAttributeValue(PATH_ATTR_NAME);
            if (interpreterPath == null) continue;
            interpreterPath = FileUtil.toSystemIndependentName((String)interpreterPath);
            boolean excluded = Boolean.parseBoolean(interpreterElement.getAttributeValue(EXCLUDED_ATTR_NAME));
            if (excluded) {
                excludedInterpreterPaths.add(interpreterPath);
                continue;
            }
            TimestampedSemVer version = NodeJsLocalInterpreterManager.parseVersionCache(interpreterElement);
            if (version != null) {
                this.myVersionCache.putIfAbsent(interpreterPath, version);
            }
            String npmPackageDirPath = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)interpreterElement, (String)NPM_TAG_NAME);
            NodeJsLocalInterpreter interpreter = new NodeJsLocalInterpreter(interpreterPath, npmPackageDirPath);
            interpreters.add(interpreter);
        }
        this.myInterpreters = interpreters;
        this.myExcludedInterpreterPaths = excludedInterpreterPaths;
    }

    @Nullable
    private static TimestampedSemVer parseVersionCache(@NotNull Element interpreterElement) {
        if (interpreterElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterElement", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "parseVersionCache"));
        }
        Element versionCacheElement = interpreterElement.getChild(VERSION_CACHE_TAG_NAME);
        if (versionCacheElement == null) {
            return null;
        }
        long lastModified = StringUtil.parseLong((String)versionCacheElement.getAttributeValue(VERSION_LAST_MODIFIED_ATTR_NAME), (long)-1L);
        if (lastModified >= 0L) {
            String versionStr = versionCacheElement.getAttributeValue(VERSION_ATTR_NAME);
            SemVer version = SemVer.parseFromText((String)StringUtil.notNullize((String)versionStr));
            return new TimestampedSemVer(version, lastModified, true);
        }
        return null;
    }

    @NotNull
    private List<NodeJsLocalInterpreter> sortInterpreters(@NotNull List<NodeJsLocalInterpreter> interpreters) {
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "sortInterpreters"));
        }
        ArrayList pairs = ContainerUtil.newArrayListWithCapacity((int)interpreters.size());
        for (NodeJsLocalInterpreter interpreter : interpreters) {
            SemVer version = (SemVer)Ref.deref(this.getCachedVersion(interpreter));
            if (version == null) {
                version = NodeJsLocalInterpreterManager.guessVersionByPath(interpreter);
            }
            pairs.add(new InterpreterWithVersion(interpreter, version));
        }
        Collections.sort(pairs);
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)interpreters.size());
        for (InterpreterWithVersion pair : pairs) {
            result.add(pair.myInterpreter);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "sortInterpreters"));
        }
        return arrayList;
    }

    @Nullable
    private static SemVer guessVersionByPath(@NotNull NodeJsLocalInterpreter interpreter) {
        int sepInd2;
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "guessVersionByPath"));
        }
        String path = interpreter.getInterpreterSystemIndependentPath();
        int sepInd1 = path.lastIndexOf(47);
        if (sepInd1 > 0 && (sepInd1 = path.lastIndexOf(47, sepInd1 - 1)) > 0 && (sepInd2 = path.lastIndexOf(47, sepInd1 - 1)) > 0) {
            String str = path.substring(sepInd2 + 1, sepInd1);
            return SemVer.parseFromText((String)StringUtil.trimStart((String)str, (String)"v"));
        }
        return null;
    }

    public void setInterpreters(@NotNull List<NodeJsLocalInterpreter> interpreters) {
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "setInterpreters"));
        }
        this.myInterpreters = ContainerUtil.newArrayList(interpreters);
        this.myExcludedInterpreterPaths = this.updateExcludedInterpreterPaths(interpreters);
    }

    @NotNull
    private Set<String> updateExcludedInterpreterPaths(@NotNull List<NodeJsLocalInterpreter> interpreters) {
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "updateExcludedInterpreterPaths"));
        }
        Set<String> detectedInterpreterPaths = this.myDetectedInterpreterPaths;
        if (detectedInterpreterPaths == null) {
            Set<String> set = this.myExcludedInterpreterPaths;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "updateExcludedInterpreterPaths"));
            }
            return set;
        }
        HashSet result = ContainerUtil.newHashSet(detectedInterpreterPaths);
        for (NodeJsLocalInterpreter interpreter : interpreters) {
            result.remove(interpreter.getInterpreterSystemIndependentPath());
        }
        this.myExcludedInterpreterPaths = result;
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "updateExcludedInterpreterPaths"));
        }
        return hashSet;
    }

    @NotNull
    public List<NodeJsLocalInterpreter> getInterpreters() {
        HashSet detectedPaths = ContainerUtil.newHashSet(this.getDetectedInterpreterPaths());
        List<Object> result = ContainerUtil.newArrayList((Iterable)ContainerUtil.notNullize(this.myInterpreters));
        for (NodeJsLocalInterpreter nodeJsLocalInterpreter : result) {
            detectedPaths.remove(nodeJsLocalInterpreter.getInterpreterSystemIndependentPath());
        }
        detectedPaths.removeAll(this.myExcludedInterpreterPaths);
        for (String string : detectedPaths) {
            result.add(new NodeJsLocalInterpreter(string, null));
        }
        result = this.sortInterpreters((List<NodeJsLocalInterpreter>)result);
        this.myInterpreters = ContainerUtil.newArrayList((Iterable)result);
        List<Object> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "getInterpreters"));
        }
        return list;
    }

    @NotNull
    public List<NodeJsLocalInterpreter> suggestToAddInterpreters() {
        Set<String> excludedInterpreterPaths = this.myExcludedInterpreterPaths;
        if (ContainerUtil.isEmpty(excludedInterpreterPaths)) {
            List<NodeJsLocalInterpreter> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "suggestToAddInterpreters"));
            }
            return list;
        }
        ArrayList interpreters = ContainerUtil.newArrayListWithCapacity((int)excludedInterpreterPaths.size());
        for (String interpreterPath : excludedInterpreterPaths) {
            File file = new File(interpreterPath);
            if (!file.isFile() || !file.canExecute()) continue;
            interpreters.add(new NodeJsLocalInterpreter(file.getAbsolutePath(), null));
        }
        List<NodeJsLocalInterpreter> list = this.sortInterpreters(interpreters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "suggestToAddInterpreters"));
        }
        return list;
    }

    @Nullable
    public NodeJsLocalInterpreter findByReferenceName(@NotNull String referenceName) {
        if (referenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "findByReferenceName"));
        }
        if (StringUtil.isEmptyOrSpaces((String)referenceName)) {
            return null;
        }
        List<NodeJsLocalInterpreter> interpreters = this.myInterpreters;
        if (interpreters == null) {
            interpreters = this.getInterpreters();
        }
        for (NodeJsLocalInterpreter interpreter : interpreters) {
            if (!interpreter.getReferenceName().equals(referenceName)) continue;
            return interpreter;
        }
        String interpreterPath = NodeJsLocalInterpreterManager.resolveInterpreterPath(referenceName);
        return new NodeJsLocalInterpreter(interpreterPath, null);
    }

    @NotNull
    private static String resolveInterpreterPath(@NotNull String referenceName) {
        if (referenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "resolveInterpreterPath"));
        }
        if (SystemInfo.isWindows) {
            String fileWithExePath = referenceName + ".exe";
            File fileWithExe = new File(fileWithExePath);
            if (fileWithExe.isFile()) {
                String string = fileWithExePath;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "resolveInterpreterPath"));
                }
                return string;
            }
            File file = new File(referenceName);
            if (file.isFile()) {
                String string = referenceName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "resolveInterpreterPath"));
                }
                return string;
            }
            String string = fileWithExePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "resolveInterpreterPath"));
            }
            return string;
        }
        String string = referenceName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager", "resolveInterpreterPath"));
        }
        return string;
    }

    @Nullable
    public NodeJsLocalInterpreter detectMostRelevant() {
        File interpreterFile = NodeDetectionUtil.findInterpreterInPath();
        if (interpreterFile == null) {
            return null;
        }
        return new NodeJsLocalInterpreter(interpreterFile.getAbsolutePath(), null);
    }

    private static class InterpreterWithVersion
    implements Comparable<InterpreterWithVersion> {
        private final NodeJsLocalInterpreter myInterpreter;
        private final SemVer myVersion;

        public InterpreterWithVersion(@NotNull NodeJsLocalInterpreter interpreter, @Nullable SemVer version) {
            if (interpreter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager$InterpreterWithVersion", "<init>"));
            }
            this.myInterpreter = interpreter;
            this.myVersion = version;
        }

        @Override
        public int compareTo(InterpreterWithVersion other) {
            SemVer version1 = this.myVersion;
            SemVer version2 = other.myVersion;
            String path1 = this.myInterpreter.getInterpreterSystemIndependentPath();
            String path2 = other.myInterpreter.getInterpreterSystemIndependentPath();
            if (version1 != null && version2 != null) {
                int res = version2.compareTo(version1);
                if (res == 0) {
                    res = path1.compareTo(path2);
                }
                return res;
            }
            if (version1 == null && version2 == null) {
                return path1.compareTo(path2);
            }
            return version1 == null ? -1 : 1;
        }
    }

    private static class TimestampedSemVer {
        private final SemVer myVersion;
        private final long myLastModified;
        private final boolean myLoadedFromXml;

        public TimestampedSemVer(@Nullable SemVer version, long lastModified, boolean loadedFromXml) {
            this.myVersion = version;
            this.myLastModified = lastModified;
            this.myLoadedFromXml = loadedFromXml;
        }
    }
}

