/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.remote;

import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreterType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Ref;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsRemoteInterpreter
extends NodeJsInterpreter {
    private final String myRemoteUrl;

    public NodeJsRemoteInterpreter(@NotNull String remoteUrl) {
        if (remoteUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteUrl", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreter", "<init>"));
        }
        this.myRemoteUrl = remoteUrl;
    }

    @Override
    @NotNull
    public String getReferenceName() {
        String string = this.myRemoteUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreter", "getReferenceName"));
        }
        return string;
    }

    @NotNull
    public String getRemoteUrl() {
        String string = this.myRemoteUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreter", "getRemoteUrl"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.myRemoteUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreter", "getPresentableName"));
        }
        return string;
    }

    @Override
    @Nullable
    public Ref<SemVer> getCachedVersion() {
        NodeJSRemoteInterpreterManager remoteInterpreterManager = NodeJSRemoteInterpreterManager.getInstance();
        if (remoteInterpreterManager != null) {
            SemVer version = remoteInterpreterManager.getNodeVersionCached(this.myRemoteUrl);
            if (version == SemVer.UNKNOWN) {
                return Ref.create();
            }
            return Ref.create((Object)version);
        }
        return null;
    }

    @Override
    public void fetchVersion(final @NotNull NullableConsumer<SemVer> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreter", "fetchVersion"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                consumer.consume(null);
            }
        });
    }

    @Override
    @NotNull
    public NodeJsInterpreterType<? extends NodeJsInterpreter> getType() {
        NodeJsRemoteInterpreterType nodeJsRemoteInterpreterType = NodeJsRemoteInterpreterType.getInstance();
        if (nodeJsRemoteInterpreterType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreter", "getType"));
        }
        return nodeJsRemoteInterpreterType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeJsRemoteInterpreter that = (NodeJsRemoteInterpreter)o;
        return this.myRemoteUrl.equals(that.myRemoteUrl);
    }

    public int hashCode() {
        return this.myRemoteUrl.hashCode();
    }

    @Nullable
    public static NodeJsRemoteInterpreter tryCast(@Nullable NodeJsInterpreter interpreter) {
        return (NodeJsRemoteInterpreter)ObjectUtils.tryCast((Object)interpreter, NodeJsRemoteInterpreter.class);
    }
}

