/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.remote;

import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterEditor;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsRemoteInterpreterType
extends NodeJsInterpreterType<NodeJsRemoteInterpreter> {
    private static final NodeJsRemoteInterpreterType INSTANCE = new NodeJsRemoteInterpreterType();
    private final NodeJSRemoteInterpreterManager myRemoteInterpreterManager = NodeJSRemoteInterpreterManager.getInstance();

    @NotNull
    public static NodeJsRemoteInterpreterType getInstance() {
        NodeJsRemoteInterpreterType nodeJsRemoteInterpreterType = INSTANCE;
        if (nodeJsRemoteInterpreterType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType", "getInstance"));
        }
        return nodeJsRemoteInterpreterType;
    }

    @Override
    @NotNull
    public String getName() {
        if ("remote" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType", "getName"));
        }
        return "remote";
    }

    @Override
    public boolean isAvailable() {
        return this.myRemoteInterpreterManager != null;
    }

    @Override
    @Nullable
    public NodeJsRemoteInterpreter findByReferenceName(@NotNull String referenceName) {
        if (referenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType", "findByReferenceName"));
        }
        return new NodeJsRemoteInterpreter(referenceName);
    }

    @Override
    @NotNull
    public List<NodeJsRemoteInterpreter> getInterpreters() {
        if (this.myRemoteInterpreterManager != null) {
            List list = ContainerUtil.map(this.myRemoteInterpreterManager.getRemoteInterpreters(), (Function)new NotNullFunction<String, NodeJsRemoteInterpreter>(){

                @NotNull
                public NodeJsRemoteInterpreter fun(String s) {
                    NodeJsRemoteInterpreter nodeJsRemoteInterpreter = new NodeJsRemoteInterpreter(s);
                    if (nodeJsRemoteInterpreter == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType$1", "fun"));
                    }
                    return nodeJsRemoteInterpreter;
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType", "getInterpreters"));
            }
            return list;
        }
        List<NodeJsRemoteInterpreter> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType", "getInterpreters"));
        }
        return list;
    }

    @Override
    @Nullable
    public NodeJsRemoteInterpreter showAddDialog(@NotNull Project project) {
        String id;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType", "showAddDialog"));
        }
        if (this.myRemoteInterpreterManager != null && (id = this.myRemoteInterpreterManager.createRemoteInterpreter(project)) != null) {
            return new NodeJsRemoteInterpreter(id);
        }
        return null;
    }

    @Override
    public boolean isInplaceEditorAvailable() {
        return false;
    }

    @Override
    @Nullable
    public NodeJsRemoteInterpreter edit(@NotNull Project project, @NotNull NodeJsRemoteInterpreter interpreter) {
        String createdId;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType", "edit"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType", "edit"));
        }
        if (this.myRemoteInterpreterManager != null && (createdId = this.myRemoteInterpreterManager.editRemoteInterpreter(project, interpreter.getRemoteUrl())) != null) {
            return new NodeJsRemoteInterpreter(createdId);
        }
        return null;
    }

    @Override
    @NotNull
    public NodeJsInterpreterEditor<NodeJsRemoteInterpreter> getEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType", "getEditor"));
        }
        MyEditor myEditor = new MyEditor();
        if (myEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType", "getEditor"));
        }
        return myEditor;
    }

    @Override
    public void setInterpreters(@NotNull List<NodeJsRemoteInterpreter> interpreters) {
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType", "setInterpreters"));
        }
        if (this.myRemoteInterpreterManager != null) {
            HashSet toDelete = ContainerUtil.newHashSet(this.myRemoteInterpreterManager.getRemoteInterpreters());
            for (NodeJsRemoteInterpreter interpreter : interpreters) {
                toDelete.remove(interpreter.getRemoteUrl());
            }
            for (String url : toDelete) {
                this.myRemoteInterpreterManager.deleteRemoteInterpreter(url);
            }
        }
    }

    private static class MyEditor
    implements NodeJsInterpreterEditor<NodeJsRemoteInterpreter> {
        private final JPanel myPanel;
        private NodeJsRemoteInterpreter myCurrent;

        public MyEditor() {
            final Ref emptyTextRef = Ref.create();
            this.myPanel = new JPanel(new BorderLayout()){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    ((StatusText)emptyTextRef.get()).paint((Component)this, g);
                }
            };
            StatusText emptyText = new StatusText(this.myPanel){

                protected boolean isStatusVisible() {
                    return true;
                }
            };
            emptyText.setText(MyEditor.getEmptyText());
            emptyTextRef.set((Object)emptyText);
            this.myPanel.setBorder(DialogWrapper.ourDefaultBorder);
        }

        @NotNull
        private static String getEmptyText() {
            Shortcut shortcut;
            ShortcutSet shortcutSet = CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.EDIT);
            if (shortcutSet != null && (shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])shortcutSet.getShortcuts())) != null) {
                String string = "Edit the selected remote interpreter with " + KeymapUtil.getShortcutText((Shortcut)shortcut);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType$MyEditor", "getEmptyText"));
                }
                return string;
            }
            if ("Edit the remote interpreter with double click" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType$MyEditor", "getEmptyText"));
            }
            return "Edit the remote interpreter with double click";
        }

        @Override
        public void resetEditor(@NotNull NodeJsRemoteInterpreter interpreter) {
            if (interpreter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType$MyEditor", "resetEditor"));
            }
            this.myCurrent = interpreter;
        }

        @Override
        @NotNull
        public NodeJsRemoteInterpreter applyEditor() {
            NodeJsRemoteInterpreter nodeJsRemoteInterpreter = this.myCurrent;
            if (nodeJsRemoteInterpreter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType$MyEditor", "applyEditor"));
            }
            return nodeJsRemoteInterpreter;
        }

        @Override
        @NotNull
        public Component getEditorComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType$MyEditor", "getEditorComponent"));
            }
            return jPanel;
        }
    }
}

