/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NodeJsCoreLibraryUtil {
    private static final Logger LOG = Logger.getInstance(NodeJsCoreLibraryUtil.class);
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> GLOBAL_STUB_FILES = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

        @NotNull
        protected Set<VirtualFile> compute() {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)NodeJsCoreLibraryUtil.listNodeGlobalStubFiles());
            if (immutableSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryUtil$1", "compute"));
            }
            return immutableSet;
        }
    };
    private static final String[] GLOBAL_STUB_NAMES = new String[]{"node-globals-stub.js", "node-buffer-stub.js", "node-console-stub.js", "node-timers-stub.js"};
    private static final String OLD_NODE_CORE_MODULE_FRAMEWORK_NAME = "Node.js Core Modules";

    private NodeJsCoreLibraryUtil() {
    }

    @NotNull
    public static Set<VirtualFile> getNodeGlobalStubFiles() {
        Set set = (Set)GLOBAL_STUB_FILES.getValue();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryUtil", "getNodeGlobalStubFiles"));
        }
        return set;
    }

    @NotNull
    private static List<VirtualFile> listNodeGlobalStubFiles() {
        ArrayList files = ContainerUtil.newArrayListWithCapacity((int)GLOBAL_STUB_NAMES.length);
        for (String name : GLOBAL_STUB_NAMES) {
            URL url = NodeJsCoreLibraryUtil.class.getResource(name);
            if (url == null) {
                LOG.error("NodeJS plugin installation is possibly broken. Cannot find " + name);
                continue;
            }
            VirtualFile file = VfsUtil.findFileByURL((URL)url);
            if (file == null || !file.isValid()) {
                LOG.error("NodeJS plugin installation is possibly broken. Cannot find virtual file for " + name + ", url: " + url.toExternalForm());
                continue;
            }
            files.add(file);
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)files);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryUtil", "listNodeGlobalStubFiles"));
        }
        return immutableList;
    }

    private static boolean isOldCoreModulesLibrary(@NotNull ScriptingLibraryModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryUtil", "isOldCoreModulesLibrary"));
        }
        ScriptingFrameworkDescriptor descriptor = model.getFrameworkDescriptor();
        return descriptor != null && !model.isPredefined() && OLD_NODE_CORE_MODULE_FRAMEWORK_NAME.equals(descriptor.getFrameworkName());
    }

    @NotNull
    public static List<ScriptingLibraryModel> listOldLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryUtil", "listOldLibraries"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        List list = ContainerUtil.filter((Object[])libraryManager.getAllLibraries(), (Condition)new Condition<ScriptingLibraryModel>(){

            public boolean value(ScriptingLibraryModel libraryModel) {
                return NodeJsCoreLibraryUtil.isOldCoreModulesLibrary(libraryModel);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryUtil", "listOldLibraries"));
        }
        return list;
    }

    public static boolean removeOldLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryUtil", "removeOldLibraries"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        JSLibraryMappings libraryMappings = JSLibraryMappings.getInstance(project);
        List<ScriptingLibraryModel> oldCoreLibraries = NodeJsCoreLibraryUtil.listOldLibraries(project);
        if (oldCoreLibraries.isEmpty()) {
            return false;
        }
        for (ScriptingLibraryModel oldLibrary : oldCoreLibraries) {
            LOG.info("Removing old Node.js library: " + oldLibrary.getName());
            List files = libraryMappings.getMappingsByLibraryName(oldLibrary.getName());
            for (VirtualFile file : files) {
                libraryMappings.disassociate(file, oldLibrary.getName());
            }
            libraryManager.removeLibrary(oldLibrary);
        }
        return true;
    }
}

