/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;

public class ES6CompletionKeywordsContributor
extends JSCompletionKeywordsContributor {
    private static final TokenSet FILE_REFERENCES = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.FROM_CLAUSE, JSTokenTypes.STRING_LITERAL});

    @Override
    public boolean process(KeywordCompletionConsumer consumer, PsiElement context) {
        JSFunction function;
        PsiElement grandParentParent;
        PsiElement grandParent;
        PsiElement parent = context.getParent();
        if (ES6CompletionKeywordsContributor.addFromKeyword(consumer, parent)) {
            return false;
        }
        if (parent instanceof ES6ImportExportSpecifier || parent instanceof ES6ImportedBinding) {
            return false;
        }
        PsiElement psiElement = grandParent = parent != null ? parent.getParent() : null;
        if (grandParent instanceof JSExpressionStatement && ((grandParentParent = grandParent.getParent()) instanceof JSBlockStatement || grandParentParent instanceof JSIfStatement) && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)grandParentParent, JSFunction.class)) != null) {
            if (function.isGenerator()) {
                consumer.consume(101, true, "yield");
            } else if (ES6PsiUtil.isAsyncContext(function)) {
                consumer.consume(101, true, "await");
            }
        }
        return super.process(consumer, context);
    }

    private static boolean addFromKeyword(KeywordCompletionConsumer consumer, PsiElement parent) {
        PsiElement prevSibling;
        if (!(parent instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof JSExpressionStatement && (prevSibling = grandParent.getPrevSibling()) instanceof PsiWhiteSpace && prevSibling.getPrevSibling() instanceof ES6ImportDeclaration && prevSibling.getPrevSibling().getNode().findChildByType(FILE_REFERENCES) == null) {
            consumer.consume(101, true, "from");
            return true;
        }
        return false;
    }

    @Override
    public void appendSpecificKeywords(KeywordCompletionConsumer consumer) {
        super.appendSpecificKeywords(consumer);
        consumer.consume(3, true, "class", "import", "export", "extends", "private", "public", "static", "yield", "async", "await", "of");
        consumer.consume(3, false, "super", "constructor");
    }

    @Override
    public void appendExpressionContextKeywords(KeywordCompletionConsumer consumer) {
        super.appendExpressionContextKeywords(consumer);
        consumer.consume(6, true, "yield");
    }
}

