/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.stubs.ES6FromClauseStub;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6FromClauseImpl
extends JSStubElementImpl<ES6FromClauseStub>
implements ES6FromClause,
StubBasedPsiElement<ES6FromClauseStub> {
    public ES6FromClauseImpl(ASTNode node) {
        super(node);
    }

    public ES6FromClauseImpl(ES6FromClauseStub stub) {
        super(stub, (IStubElementType)ES6ElementTypes.FROM_CLAUSE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/ecmascript6/psi/impl/ES6FromClauseImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitES6FromClause((ES6FromClause)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiReference[]>(){

            @Nullable
            public CachedValueProvider.Result<PsiReference[]> compute() {
                return CachedValueProvider.Result.create((Object)ES6FromClauseImpl.this.calcReferences(), (Object[])new Object[]{ES6FromClauseImpl.this});
            }
        });
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6FromClauseImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private PsiReference[] calcReferences() {
        PsiReference[] psiReferenceArray = ES6PsiUtil.calcImportExportFromClauseReferences((PsiElement)this, null);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6FromClauseImpl", "calcReferences"));
        }
        return psiReferenceArray;
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getLastElement((Object[])this.getReferences());
    }

    @NotNull
    public Collection<PsiElement> resolveReferencedElements() {
        Collection collection = (Collection)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<Collection<PsiElement>>(){
            private final Condition<PsiElement> IS_TS_MODULE = Conditions.instanceOf(TypeScriptModule.class);

            @Nullable
            public CachedValueProvider.Result<Collection<PsiElement>> compute() {
                String text = ES6FromClauseImpl.this.getReferenceText();
                if (StringUtil.isEmpty((String)text)) {
                    return CachedValueProvider.Result.create((Object)ContainerUtil.emptyList(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
                PsiReference[] references = ES6PsiUtil.createImportExportFromClauseReferences((PsiElement)ES6FromClauseImpl.this, 0, text, null);
                THashSet results = new THashSet();
                for (PsiReference reference : references) {
                    if (reference == null || reference instanceof FileReference && !((FileReference)reference).isLast()) continue;
                    Collection<PsiElement> currentResults = JSResolveUtil.getResolvedElements(reference);
                    results.addAll(currentResults);
                }
                List typeScriptModules = ContainerUtil.filter((Collection)results, this.IS_TS_MODULE);
                return CachedValueProvider.Result.create((Object)(typeScriptModules.isEmpty() ? results : typeScriptModules), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6FromClauseImpl", "resolveReferencedElements"));
        }
        return collection;
    }

    @Nullable
    public String getReferenceText() {
        ES6FromClauseStub stub = (ES6FromClauseStub)this.getStub();
        if (stub != null) {
            return stub.getReferenceText();
        }
        Pair<String, PsiElement> unquoted = JSPsiImplUtils.getChildStringLiteralWithText((PsiElement)this);
        return unquoted == null ? null : (String)unquoted.first;
    }
}

