/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ImportDeclarationStub;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportDeclarationImpl
extends JSStubElementImpl<ES6ImportDeclarationStub>
implements ES6ImportDeclaration,
StubBasedPsiElement<ES6ImportDeclarationStub>,
JSSuppressionHolder {
    private static final TokenSet IMPORT_SPECIFIER_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.IMPORT_SPECIFIER});

    public ES6ImportDeclarationImpl(ASTNode node) {
        super(node);
    }

    public ES6ImportDeclarationImpl(ES6ImportDeclarationStub stub) {
        super(stub, (IStubElementType)ES6ElementTypes.IMPORT_DECLARATION);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportDeclarationImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitES6ImportDeclaration((ES6ImportDeclaration)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        ES6ImportSpecifier[] specifiers;
        ES6ImportedBinding[] bindings;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportDeclarationImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportDeclarationImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportDeclarationImpl", "processDeclarations"));
        }
        for (ES6ImportedBinding binding : bindings = this.getImportedBindings()) {
            if (processor.execute((PsiElement)binding, state)) continue;
            return false;
        }
        for (ES6ImportSpecifier specifier : specifiers = this.getImportSpecifiers()) {
            if (specifier.processDeclarations(processor, state, lastParent, place)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ES6FromClause getFromClause() {
        return (ES6FromClause)this.getStubOrPsiChild((IStubElementType)ES6ElementTypes.FROM_CLAUSE);
    }

    @NotNull
    public ES6ImportedBinding[] getImportedBindings() {
        ES6ImportedBinding[] eS6ImportedBindingArray = (ES6ImportedBinding[])this.getStubOrPsiChildren((IStubElementType)ES6ElementTypes.IMPORTED_BINDING, ES6ImportedBinding.ARRAY_FACTORY);
        if (eS6ImportedBindingArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportDeclarationImpl", "getImportedBindings"));
        }
        return eS6ImportedBindingArray;
    }

    @NotNull
    public ES6ImportSpecifier[] getImportSpecifiers() {
        ES6ImportSpecifier[] eS6ImportSpecifierArray = (ES6ImportSpecifier[])this.getStubOrPsiChildren(IMPORT_SPECIFIER_TOKEN_SET, ES6ImportSpecifier.ARRAY_FACTORY);
        if (eS6ImportSpecifierArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportDeclarationImpl", "getImportSpecifiers"));
        }
        return eS6ImportSpecifierArray;
    }

    public String getImportModuleText() {
        Pair<String, PsiElement> literalValue = JSPsiImplUtils.getChildStringLiteralWithText((PsiElement)this);
        return literalValue == null ? null : (String)literalValue.first;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiReference[]>(){

            @Nullable
            public CachedValueProvider.Result<PsiReference[]> compute() {
                return CachedValueProvider.Result.create((Object)ES6ImportDeclarationImpl.this.calcReferences(), (Object[])new Object[]{ES6ImportDeclarationImpl.this});
            }
        });
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportDeclarationImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private PsiReference[] calcReferences() {
        PsiReference[] psiReferenceArray = ES6PsiUtil.calcImportExportFromClauseReferences((PsiElement)this, null);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportDeclarationImpl", "calcReferences"));
        }
        return psiReferenceArray;
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getLastElement((Object[])this.getReferences());
    }
}

