/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.annotations.NotNull;

public class JSFileViewProviderFactory
implements FileViewProviderFactory {
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, Language language, @NotNull PsiManager manager, boolean eventSystemEnabled) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/JSFileViewProviderFactory", "createFileViewProvider"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/javascript/JSFileViewProviderFactory", "createFileViewProvider"));
        }
        if (!SingleRootFileViewProvider.isTooLargeForContentLoading((VirtualFile)file)) {
            SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file);
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(manager, file, eventSystemEnabled){

            public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
                PsiElement element;
                Language baseLanguage;
                PsiFile psi;
                if (lang == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/lang/javascript/JSFileViewProviderFactory$1", "findElementAt"));
                }
                if (lang == XMLLanguage.class && (psi = this.getPsi(baseLanguage = this.getBaseLanguage())) != null && DialectDetector.isJSX((PsiElement)psi) && (element = this.findElementAt(offset)) != null && element.getLanguage() instanceof XMLLanguage) {
                    return element;
                }
                return super.findElementAt(offset, lang);
            }
        };
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSFileViewProviderFactory", "createFileViewProvider"));
        }
        return singleRootFileViewProvider;
    }
}

