/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageUtil {
    public static final List<Language> LANGUAGES_WITH_JAVA_SCRIPT_FORMATTER_SETTINGS = Arrays.asList(new Language[]{JavaScriptSupportLoader.ECMA_SCRIPT_6, JavaScriptSupportLoader.GWT_DIALECT});

    @NotNull
    public static Language getLanguageDialect(PsiElement element) {
        Language language = JSLanguageUtil.getLanguageDialect(element, element.getTextOffset());
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSLanguageUtil", "getLanguageDialect"));
        }
        return language;
    }

    @NotNull
    public static Language getLanguageDialect(PsiElement element, int startOffset) {
        PsiFile psiFile = element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
        Language dialect = psiFile.getLanguage();
        if (dialect == JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            Language language = dialect;
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSLanguageUtil", "getLanguageDialect"));
            }
            return language;
        }
        if (!(dialect instanceof JSLanguageDialect) && dialect.isKindOf((Language)JavascriptLanguage.INSTANCE)) {
            Language language = dialect;
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSLanguageUtil", "getLanguageDialect"));
            }
            return language;
        }
        dialect = DialectDetector.languageOfElement((PsiElement)psiFile);
        if (!(dialect instanceof JSLanguageDialect)) {
            dialect = JSLanguageUtil.getLanguage(psiFile, startOffset);
        }
        if (!(dialect instanceof JSLanguageDialect) || LANGUAGES_WITH_JAVA_SCRIPT_FORMATTER_SETTINGS.contains(dialect)) {
            dialect = JavascriptLanguage.INSTANCE;
        }
        Language language = dialect;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSLanguageUtil", "getLanguageDialect"));
        }
        return language;
    }

    @Nullable
    public static Language getLanguage(PsiFile file, int offset) {
        PsiElement at = file.findElementAt(offset);
        if (at == null && offset == file.getTextLength()) {
            at = file.findElementAt(offset - 1);
        }
        return JSLanguageUtil.getLanguage(at);
    }

    @Nullable
    public static Language getLanguage(PsiElement element) {
        PsiLanguageInjectionHost host;
        Language language;
        Language language2 = language = element != null ? element.getParent().getLanguage() : null;
        if (language != null && (host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLanguageInjectionHost.class, (boolean)false)) != null) {
            final Ref injectedLanguageRef = new Ref();
            InjectedLanguageManager.getInstance((Project)host.getProject()).enumerateEx((PsiElement)host, element.getContainingFile(), false, (PsiLanguageInjectionHost.InjectedPsiVisitor)new JSResolveUtil.JSInjectedFilesVisitor(){

                @Override
                protected void process(JSFile file) {
                    injectedLanguageRef.set((Object)file.getLanguage());
                }
            });
            if (!injectedLanguageRef.isNull()) {
                language = (Language)injectedLanguageRef.get();
            }
        }
        return language;
    }

    @NotNull
    public static Language getLanguageForParser(@NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/JSLanguageUtil", "getLanguageForParser"));
        }
        Language language = psi.getLanguage();
        if (!(language instanceof JSLanguageDialect)) {
            JSLanguageDialect dialect = DialectDetector.getLanguageDialect(psi);
            JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)psi, JSEmbeddedContent.class, (boolean)false);
            if (embeddedContent != null && dialect != JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
                Language language2 = embeddedContent.getLanguage();
                if (language2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSLanguageUtil", "getLanguageForParser"));
                }
                return language2;
            }
            if (dialect != null) {
                JSLanguageDialect jSLanguageDialect = dialect;
                if (jSLanguageDialect == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSLanguageUtil", "getLanguageForParser"));
                }
                return jSLanguageDialect;
            }
        }
        Language language3 = language;
        if (language3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSLanguageUtil", "getLanguageForParser"));
        }
        return language3;
    }
}

