/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptJsonSchemaProviderFactory
implements JsonSchemaProviderFactory {
    private static final Logger LOG = Logger.getInstance(JavaScriptJsonSchemaProviderFactory.class);
    private static final String[] FILENAMES = new String[]{".babelrc", "tsconfig.json", "tsd.json", "typings.json", ".eslintrc"};
    private static final String PATH = "jsonSchemas";
    private final JsonSchemaFileProvider[] myProviders;

    public JavaScriptJsonSchemaProviderFactory() {
        ArrayList providers = ContainerUtil.newArrayList();
        for (String filename : FILENAMES) {
            providers.add(JavaScriptJsonSchemaProviderFactory.createProvider(filename));
        }
        this.myProviders = providers.toArray(new JsonSchemaFileProvider[providers.size()]);
    }

    private static JsonSchemaFileProvider createProvider(final @NotNull String filename) {
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filename", "com/intellij/lang/javascript/JavaScriptJsonSchemaProviderFactory", "createProvider"));
        }
        return new JsonSchemaFileProvider(){

            public boolean isAvailable(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/JavaScriptJsonSchemaProviderFactory$1", "isAvailable"));
                }
                return filename.equals(file.getName());
            }

            @Nullable
            public Reader getSchemaReader() {
                String content = JavaScriptJsonSchemaProviderFactory.getContent(filename);
                return content != null ? new StringReader(content) : null;
            }
        };
    }

    private static String getContent(@NotNull String filename) {
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filename", "com/intellij/lang/javascript/JavaScriptJsonSchemaProviderFactory", "getContent"));
        }
        ClassLoader loader = JavaScriptJsonSchemaProviderFactory.class.getClassLoader();
        try {
            URL resource = loader.getResource("jsonSchemas/" + filename);
            assert (resource != null);
            return ResourceUtil.loadText((URL)resource);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public JsonSchemaFileProvider[] getProviders(@Nullable Project project) {
        return this.myProviders;
    }
}

