/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.parsing.JSDocParsing;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JsErrorFilter
extends HighlightErrorFilter {
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        PsiElement context;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/JsErrorFilter", "shouldHighlightErrorElement"));
        }
        if (JSDocParsing.isInsideJSDoc((PsiElement)element)) {
            return false;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile.getLanguage() != HTMLLanguage.INSTANCE || (context = containingFile.getContext()) == null) {
            return true;
        }
        boolean withinExpression = context.getParent() instanceof JSExpression;
        String errorDescription = element.getErrorDescription();
        if (this.isErrorToBeFiltered(errorDescription)) {
            return false;
        }
        if (errorDescription.indexOf("missing") != -1) {
            return !withinExpression;
        }
        return true;
    }

    private boolean isErrorToBeFiltered(String errorDescription) {
        return errorDescription.indexOf("is not closed") != -1 || errorDescription.indexOf("is not completed") != -1 || errorDescription.indexOf("expected") != -1 || errorDescription.indexOf("not terminated") != -1 || errorDescription.indexOf("Unclosed string") != -1 || errorDescription.indexOf("Unexpected tokens") != -1;
    }
}

