/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.lang.javascript.bower.BowerView;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsBowerSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class BowerSettingsManager
implements PersistentStateComponent<Element> {
    private static final String NODE_INTERPRETER_PATH = "javascript.bower.node-interpreter";
    private static final String EXE_PATH = "exe-path";
    private static final String CONFIG_PATH = "config-path";
    private BowerSettings mySettings;

    public BowerSettingsManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/bower/BowerSettingsManager", "<init>"));
        }
        this.mySettings = new BowerSettings.Builder().setNodeInterpreterPath(BowerSettingsManager.loadNodeInterpreterPathOrGuess()).setBowerExecutablePath(BowerSettingsManager.guessBowerExecutable(project)).setBowerJsonPath(BowerSettingsManager.guessBowerConfig(project)).build();
    }

    @NotNull
    private static String guessBowerExecutable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/bower/BowerSettingsManager", "guessBowerExecutable"));
        }
        List<String> exePaths = BowerView.calcPossibleBowerExecutableFiles(project);
        String string = StringUtil.notNullize((String)((String)ContainerUtil.getFirstItem(exePaths)));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettingsManager", "guessBowerExecutable"));
        }
        return string;
    }

    @NotNull
    private static String guessBowerConfig(@NotNull Project project) {
        VirtualFile bowerJson;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/bower/BowerSettingsManager", "guessBowerConfig"));
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null && baseDir.isValid() && (bowerJson = baseDir.findChild("bower.json")) != null && bowerJson.isValid() && !bowerJson.isDirectory()) {
            String string = FileUtil.toSystemDependentName((String)bowerJson.getPath());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettingsManager", "guessBowerConfig"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettingsManager", "guessBowerConfig"));
        }
        return "";
    }

    @Nullable
    public Element getState() {
        BowerSettings settings = this.mySettings;
        Element root = new Element("js-bower-settings");
        Element exePathElement = new Element(EXE_PATH);
        exePathElement.addContent((Content)new Text(settings.getBowerExecutablePath()));
        root.addContent(exePathElement);
        Element configPathElement = new Element(CONFIG_PATH);
        configPathElement.addContent((Content)new Text(settings.getBowerJsonPath()));
        root.addContent(configPathElement);
        return root;
    }

    public void loadState(Element state) {
        if (state != null) {
            Element configPathElement;
            BowerSettings.Builder builder = this.mySettings.createBuilder();
            Element exePathElement = state.getChild(EXE_PATH);
            if (exePathElement != null) {
                builder.setBowerExecutablePath(exePathElement.getText());
            }
            if ((configPathElement = state.getChild(CONFIG_PATH)) != null) {
                builder.setBowerJsonPath(configPathElement.getText());
            }
            this.mySettings = builder.build();
        }
    }

    @NotNull
    public BowerSettings getSettings() {
        BowerSettings bowerSettings = this.mySettings;
        if (bowerSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettingsManager", "getSettings"));
        }
        return bowerSettings;
    }

    public void setSettings(@NotNull BowerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerSettingsManager", "setSettings"));
        }
        this.mySettings = settings;
        BowerSettingsManager.storeNodeInterpreterPath(settings.getNodeInterpreterPath());
    }

    @NotNull
    public static BowerSettingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/bower/BowerSettingsManager", "getInstance"));
        }
        BowerSettingsManager bowerSettingsManager = (BowerSettingsManager)ServiceManager.getService((Project)project, BowerSettingsManager.class);
        if (bowerSettingsManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettingsManager", "getInstance"));
        }
        return bowerSettingsManager;
    }

    private static String loadNodeInterpreterPathOrGuess() {
        File interpreterFile;
        String interpreter = BowerSettingsManager.loadNodeInterpreterPath();
        if (interpreter.isEmpty() && (interpreterFile = NodeDetectionUtil.findInterpreterInPath()) != null) {
            interpreter = interpreterFile.getAbsolutePath();
        }
        return interpreter;
    }

    @NotNull
    private static String loadNodeInterpreterPath() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String string = StringUtil.notNullize((String)propertiesComponent.getValue(NODE_INTERPRETER_PATH));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettingsManager", "loadNodeInterpreterPath"));
        }
        return string;
    }

    private static void storeNodeInterpreterPath(@NotNull String nodeInterpreterPath) {
        if (nodeInterpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreterPath", "com/intellij/lang/javascript/bower/BowerSettingsManager", "storeNodeInterpreterPath"));
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        propertiesComponent.setValue(NODE_INTERPRETER_PATH, nodeInterpreterPath);
    }
}

