/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtRefactoringElementListenerProvider
implements RefactoringElementListenerProvider {
    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        final VirtualFile oldBuildfile = PsiUtilBase.asVirtualFile((PsiElement)element);
        if (oldBuildfile != null) {
            final Project project = element.getProject();
            for (JsbtService service : (JsbtService[])JsbtService.EP_NAME.getExtensions()) {
                JsbtFileManager fileManager = service.getFileManager(project);
                if (!fileManager.containsBuildfile(oldBuildfile)) continue;
                return new RefactoringElementAdapter(){

                    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        if (newElement == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider$1", "elementRenamedOrMoved"));
                        }
                        VirtualFile newBuildfile = PsiUtilBase.asVirtualFile((PsiElement)newElement);
                        JsbtRefactoringElementListenerProvider.update(project, oldBuildfile, newBuildfile);
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        if (newElement == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider$1", "undoElementMovedOrRenamed"));
                        }
                        if (oldQualifiedName == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider$1", "undoElementMovedOrRenamed"));
                        }
                        VirtualFile newBuildfile = PsiUtilBase.asVirtualFile((PsiElement)newElement);
                        if (newBuildfile != null) {
                            JsbtRefactoringElementListenerProvider.update(project, newBuildfile, oldBuildfile);
                        }
                    }
                };
            }
        }
        return null;
    }

    private static void update(@NotNull Project project, @NotNull VirtualFile oldBuildfile, @Nullable VirtualFile newBuildfile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider", "update"));
        }
        if (oldBuildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldBuildfile", "com/intellij/lang/javascript/buildTools/base/JsbtRefactoringElementListenerProvider", "update"));
        }
        ArrayList fileManagers = ContainerUtil.newArrayList();
        for (JsbtService service : (JsbtService[])JsbtService.EP_NAME.getExtensions()) {
            JsbtFileManager fileManager = service.getFileManager(project);
            if (!fileManager.containsBuildfile(oldBuildfile)) continue;
            fileManagers.add(fileManager);
            fileManager.removeBuildfile(oldBuildfile);
            if (newBuildfile == null) continue;
            fileManager.addBuildfile(newBuildfile);
        }
    }
}

