/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsbtStartupActivity
implements StartupActivity,
DumbAware {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "runActivity"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ArrayList servicesForDetection = null;
        for (JsbtService service : (JsbtService[])JsbtService.EP_NAME.getExtensions()) {
            JsbtFileManager fileManager = service.getFileManager(project);
            if (fileManager.hasBuildfiles()) {
                JsbtStartupActivity.setAvailable(project, service, Collections.emptyList());
                continue;
            }
            if (fileManager.isDetectionDone()) continue;
            fileManager.setDetectionDone();
            if (servicesForDetection == null) {
                servicesForDetection = ContainerUtil.newArrayList();
            }
            servicesForDetection.add(service);
        }
        if (servicesForDetection != null) {
            JsbtStartupActivity.scheduleDetection(project, servicesForDetection);
        }
    }

    private static void scheduleDetection(final @NotNull Project project, final @NotNull List<JsbtService> servicesForDetection) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "scheduleDetection"));
        }
        if (servicesForDetection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servicesForDetection", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "scheduleDetection"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                RefreshQueue.getInstance().refresh(true, true, new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                            @Override
                            public void run() {
                                JsbtStartupActivity.doDetect(project, servicesForDetection);
                            }
                        });
                    }
                }, ManagingFS.getInstance().getRoots((NewVirtualFileSystem)LocalFileSystem.getInstance()));
            }
        }, ModalityState.NON_MODAL, project.getDisposed());
    }

    private static void doDetect(final @NotNull Project project, final @NotNull List<JsbtService> servicesForDetection) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "doDetect"));
        }
        if (servicesForDetection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servicesForDetection", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "doDetect"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                for (JsbtService service : servicesForDetection) {
                    List<VirtualFile> buildfiles = service.detectAllBuildfilesInContentRoots(project, true, true);
                    if (buildfiles.isEmpty()) continue;
                    JsbtStartupActivity.setAvailable(project, service, buildfiles);
                }
            }
        });
    }

    private static void setAvailable(final @NotNull Project project, final @NotNull JsbtService service, final @NotNull List<VirtualFile> buildfilesToAdd) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "setAvailable"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "setAvailable"));
        }
        if (buildfilesToAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfilesToAdd", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "setAvailable"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                for (VirtualFile buildfile : buildfilesToAdd) {
                    service.getFileManager(project).addBuildfile(buildfile);
                }
                service.getToolWindowManager(project).setAvailable();
            }
        });
    }
}

