/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.javascript.buildTools.base.JsbtInvalidSetting;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskListFetchFail;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtTaskFetchException
extends Exception {
    private final VirtualFile myBuildfile;
    private final List<JsbtInvalidSetting> myInvalidSettings;
    private final JsbtTaskListFetchFail myFetchFail;

    private JsbtTaskFetchException(@NotNull VirtualFile buildfile, @NotNull List<JsbtInvalidSetting> invalidSettings, @Nullable JsbtTaskListFetchFail fetchFail) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "<init>"));
        }
        if (invalidSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidSettings", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "<init>"));
        }
        this.myBuildfile = buildfile;
        this.myInvalidSettings = ImmutableList.copyOf(invalidSettings);
        this.myFetchFail = fetchFail;
    }

    @NotNull
    public VirtualFile getBuildfile() {
        VirtualFile virtualFile = this.myBuildfile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "getBuildfile"));
        }
        return virtualFile;
    }

    public boolean hasInvalidSettings() {
        return !this.myInvalidSettings.isEmpty();
    }

    @Nullable
    public JsbtTaskListFetchFail getFetchFail() {
        return this.myFetchFail;
    }

    @NotNull
    public String getDescription() {
        if (!this.myInvalidSettings.isEmpty()) {
            StringBuilder buf = new StringBuilder("Cannot fetch task list, because of invalid parameters:");
            for (JsbtInvalidSetting setting : this.myInvalidSettings) {
                buf.append("\n");
                buf.append(setting.getName()).append(":").append(setting.getValue()).append(" (").append(setting.getErrorMessage()).append(")");
            }
            String string = buf.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "getDescription"));
            }
            return string;
        }
        if (this.myFetchFail != null) {
            String string = this.myFetchFail.getDescription();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "getDescription"));
            }
            return string;
        }
        throw new AssertionError((Object)"Unreachable assertion");
    }

    @NotNull
    public static JsbtTaskFetchException newInvalidSettings(@NotNull VirtualFile buildfile, @NotNull List<JsbtInvalidSetting> invalidSettings) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "newInvalidSettings"));
        }
        if (invalidSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidSettings", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "newInvalidSettings"));
        }
        JsbtTaskFetchException jsbtTaskFetchException = new JsbtTaskFetchException(buildfile, invalidSettings, null);
        if (jsbtTaskFetchException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "newInvalidSettings"));
        }
        return jsbtTaskFetchException;
    }

    @NotNull
    public static JsbtTaskFetchException newBuildfileSyntaxError(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "newBuildfileSyntaxError"));
        }
        JsbtTaskFetchException jsbtTaskFetchException = new JsbtTaskFetchException(buildfile, (List<JsbtInvalidSetting>)ImmutableList.of(), null);
        if (jsbtTaskFetchException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "newBuildfileSyntaxError"));
        }
        return jsbtTaskFetchException;
    }

    @NotNull
    public static JsbtTaskFetchException newFetchFail(@NotNull VirtualFile buildfile, @NotNull JsbtService service, @NotNull String buildToolName, @Nullable Icon icon, @NotNull String message, @NotNull GeneralCommandLine commandLine, @Nullable String commandLineFoldedText, @Nullable ExecutionException executionException, @Nullable ProcessHandler processHandler, @Nullable ProcessOutput processOutput) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "newFetchFail"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "newFetchFail"));
        }
        if (buildToolName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildToolName", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "newFetchFail"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "newFetchFail"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "newFetchFail"));
        }
        JsbtTaskFetchException jsbtTaskFetchException = new JsbtTaskFetchException(buildfile, (List<JsbtInvalidSetting>)ImmutableList.of(), new JsbtTaskListFetchFail(buildfile, service, buildToolName, icon, message, commandLine, commandLineFoldedText, executionException, processHandler, processOutput));
        if (jsbtTaskFetchException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskFetchException", "newFetchFail"));
        }
        return jsbtTaskFetchException;
    }
}

