/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base.actions;

import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class JsbtServiceComboBoxAction
extends ComboBoxAction
implements DumbAware {
    private JsbtService mySelectedService;

    public JsbtServiceComboBoxAction(@NotNull JsbtService service) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/actions/JsbtServiceComboBoxAction", "<init>"));
        }
        this.mySelectedService = service;
    }

    public JComponent createCustomComponent(Presentation presentation) {
        ComboBoxAction.ComboBoxButton button = this.createComboBoxButton(presentation);
        button.setOpaque(false);
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add((Component)button);
        panel.setBorder((Border)JBUI.Borders.emptyRight((int)4));
        panel.setOpaque(false);
        return panel;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        JsbtService[] services = (JsbtService[])JsbtService.EP_NAME.getExtensions();
        Arrays.sort(services, new Comparator<JsbtService>(){

            @Override
            public int compare(JsbtService service1, JsbtService service2) {
                return service1.getName().compareToIgnoreCase(service2.getName());
            }
        });
        DefaultActionGroup group = new DefaultActionGroup();
        for (JsbtService service : services) {
            group.add((AnAction)new JsbtServiceVariantAction(service));
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/actions/JsbtServiceComboBoxAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setText(this.mySelectedService.getName());
    }

    protected void onValueChanged(@NotNull JsbtService service, @NotNull AnActionEvent e) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/actions/JsbtServiceComboBoxAction", "onValueChanged"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/actions/JsbtServiceComboBoxAction", "onValueChanged"));
        }
        this.mySelectedService = service;
        this.update(e);
    }

    private class JsbtServiceVariantAction
    extends AnAction
    implements DumbAware {
        private final JsbtService myService;

        public JsbtServiceVariantAction(JsbtService service) {
            if (service == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/actions/JsbtServiceComboBoxAction$JsbtServiceVariantAction", "<init>"));
            }
            super(service.getName(), null, service.getIcon());
            this.myService = service;
        }

        public void actionPerformed(AnActionEvent e) {
            JsbtServiceComboBoxAction.this.onValueChanged(this.myService, e);
        }
    }
}

