/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base.actions;

import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtShowTasksAction
extends AnAction
implements DumbAware {
    public JsbtShowTasksAction() {
        super(" ", null, null);
    }

    public void update(AnActionEvent e) {
        JsbtService service;
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project != null && file != null && (service = JsbtShowTasksAction.findService(file)) != null) {
            e.getPresentation().setEnabledAndVisible(true);
            e.getPresentation().setText("Show " + service.getMenuItemDisplayName());
            e.getPresentation().setIcon(service.getIcon());
            return;
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    public void actionPerformed(AnActionEvent e) {
        JsbtService service;
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project != null && file != null && (service = JsbtShowTasksAction.findService(file)) != null) {
            service.getFileManager(project).addBuildfile(file);
            service.getToolWindowManager(project).show(true);
        }
    }

    @Nullable
    private static JsbtService findService(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/base/actions/JsbtShowTasksAction", "findService"));
        }
        for (JsbtService service : (JsbtService[])JsbtService.EP_NAME.getExtensions()) {
            if (!service.isBuildfileName(file.getName())) continue;
            return service;
        }
        return null;
    }
}

