/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettingsManager;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfiguration;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfigurationEditor;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.ReadonlyFieldWithHistoryWithBrowseButton;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntTaskListingSettingsDialog
extends DialogWrapper {
    private final ReadonlyFieldWithHistoryWithBrowseButton myNodeInterpreterField;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final TextFieldWithHistoryWithBrowseButton myGruntCliPackageTextFieldWithBrowseButton;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final JPanel myPanel;
    private final Project myProject;

    protected GruntTaskListingSettingsDialog(@NotNull Project project, @Nullable VirtualFile contextGruntfile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskListingSettingsDialog", "<init>"));
        }
        super(project, false);
        this.myProject = project;
        this.setTitle("Grunt Settings");
        this.myNodeInterpreterField = NodeUIUtil.createNodeInterpreterTextField(project);
        this.myNodeOptionsEditor = GruntRunConfigurationEditor.createNodeOptionsEditor();
        this.myGruntCliPackageTextFieldWithBrowseButton = GruntRunConfigurationEditor.createGruntPackageDirTextFieldWithBrowseButton(project, this.myNodeInterpreterField, contextGruntfile);
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(JSBundle.message((String)"grunt.rc.nodeInterpreter.label", (Object[])new Object[0]), this.myNodeInterpreterField.getComponent()).addLabeledComponent(JSBundle.message((String)"grunt.rc.nodeOptions.label", (Object[])new Object[0]), (JComponent)this.myNodeOptionsEditor).addLabeledComponent(JSBundle.message((String)"grunt.rc.gruntCliPackage.label", (Object[])new Object[0]), (JComponent)this.myGruntCliPackageTextFieldWithBrowseButton).addLabeledComponent(JSBundle.message((String)"grunt.rc.environmentVariables.label", (Object[])new Object[0]), (JComponent)this.myEnvVarsComponent).getPanel();
        GruntNonSharedSettings settings = GruntNonSharedSettingsManager.getInstance(project).get(contextGruntfile);
        this.myNodeInterpreterField.set(settings.getNodeInterpreterPath());
        this.myGruntCliPackageTextFieldWithBrowseButton.setTextAndAddToHistory(settings.getGruntCliPackageDirPath());
        GruntRunSettings templateRunSettings = GruntRunConfiguration.getTemplateRunSettings(project);
        this.myNodeOptionsEditor.setText(templateRunSettings.getNodeOptions());
        this.myEnvVarsComponent.setData(templateRunSettings.getEnvData());
        this.configurePreferredWidth();
        this.init();
    }

    private void configurePreferredWidth() {
        this.myNodeInterpreterField.setPreferredWidthToFitText();
        SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myGruntCliPackageTextFieldWithBrowseButton);
        int width = Math.max(this.myNodeInterpreterField.getComponent().getPreferredSize().width, this.myGruntCliPackageTextFieldWithBrowseButton.getPreferredSize().width);
        width = Math.max(width, 300);
        SwingHelper.setPreferredWidth((Component)this.myNodeInterpreterField.getComponent(), (int)width);
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNodeInterpreterField.getComponent();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String nodeInterpreterError = GruntTaskListingSettingsDialog.validateNodeInterpreter(this.myNodeInterpreterField.get());
        if (nodeInterpreterError != null) {
            return new ValidationInfo(nodeInterpreterError, this.myNodeInterpreterField.getComponent());
        }
        String gruntCliPackageError = GruntTaskListingSettingsDialog.validateGruntCliPackage(this.myGruntCliPackageTextFieldWithBrowseButton.getText());
        if (gruntCliPackageError != null) {
            return new ValidationInfo(gruntCliPackageError, (JComponent)((TextFieldWithHistory)this.myGruntCliPackageTextFieldWithBrowseButton.getChildComponent()).getTextEditor());
        }
        return null;
    }

    @Nullable
    private static String validateNodeInterpreter(@NotNull String nodeInterpreter) {
        if (nodeInterpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreter", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskListingSettingsDialog", "validateNodeInterpreter"));
        }
        if (StringUtil.isEmptyOrSpaces((String)nodeInterpreter)) {
            return "Please specify node interpreter";
        }
        File file = new File(nodeInterpreter);
        if (!file.isAbsolute() || !file.isFile()) {
            return "Please specify node interpreter correctly";
        }
        return null;
    }

    @Nullable
    private static String validateGruntCliPackage(@NotNull String gruntCliPackageDir) {
        if (gruntCliPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntCliPackageDir", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskListingSettingsDialog", "validateGruntCliPackage"));
        }
        if (StringUtil.isEmptyOrSpaces((String)gruntCliPackageDir)) {
            return "Please specify grunt-cli package";
        }
        File file = new File(gruntCliPackageDir);
        if (!file.isAbsolute() || !file.isDirectory()) {
            return "Please specify grunt-cli package correctly";
        }
        return null;
    }

    protected void doOKAction() {
        this.apply();
        super.doOKAction();
    }

    private void apply() {
        GruntNonSharedSettingsManager.getInstance(this.myProject).set(this.myNodeInterpreterField.get(), this.myGruntCliPackageTextFieldWithBrowseButton.getText());
        GruntRunSettings templateRunSettings = GruntRunConfiguration.getTemplateRunSettings(this.myProject);
        GruntRunSettings.Builder builder = new GruntRunSettings.Builder(templateRunSettings);
        builder.setNodeOptions(this.myNodeOptionsEditor.getText());
        builder.setEnvData(this.myEnvVarsComponent.getData());
        GruntRunConfiguration.setTemplateRunSettings(this.myProject, builder.build());
    }
}

